/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.Collections;
import java.util.Objects;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.BelowName;
import me.neznamy.tab.shared.features.YellowNumber;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;

public class NickCompatibility
extends TabFeature {
    private final NameTag nameTags = (NameTag)TAB.getInstance().getTeamManager();
    private final BelowName belowname = (BelowName)TAB.getInstance().getFeatureManager().getFeature("BelowName");
    private final YellowNumber yellownumber = (YellowNumber)TAB.getInstance().getFeatureManager().getFeature("YellowNumber");
    private RedisSupport redis;

    public NickCompatibility() {
        super("Nick compatibility", null);
        TAB.getInstance().debug("Loaded NickCompatibility feature");
    }

    @Override
    public void load() {
        this.redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo packet) {
        if (packet.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            RedisPlayer redisPlayer;
            TabPlayer packetPlayer = TAB.getInstance().getPlayerByTabListUUID(data.getUniqueId());
            if (packetPlayer != null && packetPlayer != receiver && !packetPlayer.getNickname().equals(data.getName())) {
                ((ITabPlayer)packetPlayer).setNickname(data.getName());
                TAB.getInstance().debug("Processing name change of player " + packetPlayer.getName() + " to " + data.getName());
                this.processNameChange(packetPlayer);
            }
            if (this.redis == null || (redisPlayer = this.redis.getRedisPlayers().get(data.getUniqueId().toString())) == null || redisPlayer.getNickName().equals(data.getName())) continue;
            redisPlayer.setNickName(data.getName());
            TAB.getInstance().debug("Processing name change of redis player " + redisPlayer.getName() + " to " + data.getName());
            this.processNameChange(redisPlayer);
        }
    }

    private void processNameChange(TabPlayer player) {
        TAB.getInstance().getCPUManager().runMeasuredTask(this, "PacketPlayOutPlayerInfo", () -> {
            if (this.nameTags != null && !this.nameTags.hasTeamHandlingPaused(player)) {
                for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                    viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(player.getTeamName()), this);
                    String replacedPrefix = player.getProperty("tagprefix").getFormat(viewer);
                    String replacedSuffix = player.getProperty("tagsuffix").getFormat(viewer);
                    viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardTeam(player.getTeamName(), replacedPrefix, replacedSuffix, this.nameTags.translate(this.nameTags.getTeamVisibility(player, viewer)), this.nameTags.translate(this.nameTags.getCollisionManager().getCollision(player)), Collections.singletonList(player.getNickname()), 2), this);
                }
            }
            if (this.belowname != null) {
                int value = this.belowname.getValue(player);
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    if (!all.getWorld().equals(player.getWorld()) || !Objects.equals(all.getServer(), player.getServer())) continue;
                    all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-BelowName", player.getNickname(), value), this);
                }
            }
            if (this.yellownumber != null) {
                int value = this.yellownumber.getValue(player);
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-YellowNumber", player.getNickname(), value), this);
                }
            }
        });
    }

    private void processNameChange(RedisPlayer player) {
        TAB.getInstance().getCPUManager().runMeasuredTask(this, "PacketPlayOutPlayerInfo", () -> {
            PacketPlayOutScoreboardScore packet;
            if (this.nameTags != null) {
                PacketPlayOutScoreboardTeam unregister = player.getUnregisterTeamPacket();
                PacketPlayOutScoreboardTeam register = player.getRegisterTeamPacket();
                TabPlayer[] tabPlayerArray = TAB.getInstance().getOnlinePlayers();
                int n = tabPlayerArray.length;
                for (int i = 0; i < n; ++i) {
                    TabPlayer viewer = tabPlayerArray[i];
                    viewer.sendCustomPacket((TabPacket)unregister, this);
                    viewer.sendCustomPacket((TabPacket)register, this);
                }
            }
            if (this.belowname != null) {
                packet = player.getBelowNameUpdatePacket();
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    if (!Objects.equals(all.getServer(), player.getServer())) continue;
                    all.sendCustomPacket((TabPacket)packet, this);
                }
            }
            if (this.yellownumber != null) {
                packet = player.getYellowNumberUpdatePacket();
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    all.sendCustomPacket((TabPacket)packet, this);
                }
            }
        });
    }
}

