/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.Map;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.Layout;
import me.neznamy.tab.shared.features.layout.LayoutManager;
import me.neznamy.tab.shared.features.layout.ParentGroup;
import me.neznamy.tab.shared.features.layout.PlayerSlot;

public class PingSpoof
extends TabFeature {
    private final int value = TAB.getInstance().getConfiguration().getConfig().getInt("ping-spoof.value", 0);
    private LayoutManager layoutManager;

    public PingSpoof() {
        super("Ping spoof", null);
        TAB.getInstance().debug(String.format("Loaded PingSpoof feature with parameters value=%s", this.value));
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
        if (info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_LATENCY && info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
            Layout layout;
            if (TAB.getInstance().getPlayerByTabListUUID(playerInfoData.getUniqueId()) != null) {
                playerInfoData.setLatency(this.value);
            }
            if (this.layoutManager == null || (layout = this.layoutManager.getPlayerViews().get(receiver)) == null) continue;
            for (ParentGroup group : layout.getGroups()) {
                for (Map.Entry<Integer, PlayerSlot> entry : group.getPlayerSlots().entrySet()) {
                    if (this.layoutManager.getUUID(entry.getKey()) != playerInfoData.getUniqueId() || entry.getValue().getPlayer() == null) continue;
                    playerInfoData.setLatency(this.value);
                }
            }
        }
    }

    @Override
    public void load() {
        this.layoutManager = (LayoutManager)TAB.getInstance().getFeatureManager().getFeature("layout");
        this.updateAll(false);
    }

    @Override
    public void unload() {
        this.updateAll(true);
    }

    private void updateAll(boolean realPing) {
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(p.getUniqueId(), realPing ? p.getPing() : this.value));
        }
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_LATENCY, list), this);
        }
    }
}

