/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;

public class SpectatorFix
extends TabFeature {
    public SpectatorFix() {
        super("Spectator fix", null);
        TAB.getInstance().debug("Loaded SpectatorFix feature");
    }

    private void updateAll(boolean realGameMode) {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.hasPermission("tab.spectatorbypass")) continue;
            ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                if (p == target) continue;
                list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(target.getUniqueId(), realGameMode ? PacketPlayOutPlayerInfo.EnumGamemode.VALUES[target.getGamemode() + 1] : PacketPlayOutPlayerInfo.EnumGamemode.CREATIVE));
            }
            p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_GAME_MODE, list), this);
        }
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
        if (info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_GAME_MODE && info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
            TabPlayer changed;
            if (playerInfoData.getGameMode() != PacketPlayOutPlayerInfo.EnumGamemode.SPECTATOR || receiver.hasPermission("tab.spectatorbypass") || (changed = TAB.getInstance().getPlayerByTabListUUID(playerInfoData.getUniqueId())) == receiver) continue;
            playerInfoData.setGameMode(PacketPlayOutPlayerInfo.EnumGamemode.CREATIVE);
        }
    }

    @Override
    public void onJoin(TabPlayer p) {
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
            if (p == target || target.getGamemode() != 3) continue;
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(target.getUniqueId(), PacketPlayOutPlayerInfo.EnumGamemode.CREATIVE));
        }
        if (list.isEmpty() || p.hasPermission("tab.spectatorbypass")) {
            return;
        }
        p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_GAME_MODE, list), this);
    }

    @Override
    public void load() {
        this.updateAll(false);
    }

    @Override
    public void unload() {
        this.updateAll(true);
    }
}

