/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.Arrays;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.redis.RedisSupport;

public class YellowNumber
extends TabFeature {
    public static final String OBJECTIVE_NAME = "TAB-YellowNumber";
    public static final int DISPLAY_SLOT = 0;
    private static final String TITLE = "PlayerListObjectiveTitle";
    private final String rawValue = TAB.getInstance().getConfiguration().getConfig().getString("yellow-number-in-tablist.value", "%ping%");
    private final PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay displayType = "%health%".equals(this.rawValue) || "%player_health%".equals(this.rawValue) || "%player_health_rounded%".equals(this.rawValue) ? PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.HEARTS : PacketPlayOutScoreboardObjective.EnumScoreboardHealthDisplay.INTEGER;

    public YellowNumber() {
        super("Yellow number", "Updating value", "yellow-number-in-tablist");
        TAB.getInstance().debug(String.format("Loaded YellowNumber feature with parameters value=%s, disabledWorlds=%s, disabledServers=%s, displayType=%s", new Object[]{this.rawValue, Arrays.toString(this.disabledWorlds), Arrays.toString(this.disabledServers), this.displayType}));
    }

    public int getValue(TabPlayer p) {
        return TAB.getInstance().getErrorManager().parseInteger(p.getProperty("yellow-number").updateAndGet(), 0);
    }

    @Override
    public void load() {
        for (TabPlayer loaded : TAB.getInstance().getOnlinePlayers()) {
            loaded.setProperty(this, "yellow-number", this.rawValue);
            if (this.isDisabled(loaded.getServer(), loaded.getWorld())) {
                this.addDisabledPlayer(loaded);
                continue;
            }
            loaded.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, OBJECTIVE_NAME, TITLE, this.displayType), this);
            loaded.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(0, OBJECTIVE_NAME), this);
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(viewer)) continue;
            for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
                viewer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, target.getNickname(), this.getValue(target)), this);
            }
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(p)) continue;
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(OBJECTIVE_NAME), this);
        }
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        connectedPlayer.setProperty(this, "yellow-number", this.rawValue);
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, OBJECTIVE_NAME, TITLE, this.displayType), this);
        connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(0, OBJECTIVE_NAME), this);
        int value = this.getValue(connectedPlayer);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all == connectedPlayer) {
                connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, connectedPlayer.getNickname(), value), this);
                continue;
            }
            if (this.isDisabledPlayer(all)) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, connectedPlayer.getNickname(), value), this);
            connectedPlayer.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, all.getNickname(), this.getValue(all)), this);
        }
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        this.onWorldChange(p, null, null);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        boolean disabledBefore = this.isDisabledPlayer(p);
        boolean disabledNow = false;
        if (this.isDisabled(p.getServer(), p.getWorld())) {
            disabledNow = true;
            this.addDisabledPlayer(p);
        } else {
            this.removeDisabledPlayer(p);
        }
        if (disabledNow && !disabledBefore) {
            p.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(OBJECTIVE_NAME), this);
        }
        if (!disabledNow && disabledBefore) {
            this.onJoin(p);
            RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
            if (redis != null) {
                redis.updateYellowNumber(p, p.getProperty("yellow-number").get());
            }
        }
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        int value = this.getValue(refreshed);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (this.isDisabledPlayer(all)) continue;
            all.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, refreshed.getNickname(), value), this);
        }
        RedisSupport redis = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        if (redis != null) {
            redis.updateYellowNumber(refreshed, refreshed.getProperty("yellow-number").get());
        }
    }

    @Override
    public void onLoginPacket(TabPlayer packetReceiver) {
        if (this.isDisabledPlayer(packetReceiver)) {
            return;
        }
        packetReceiver.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardObjective(0, OBJECTIVE_NAME, TITLE, this.displayType), this);
        packetReceiver.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardDisplayObjective(0, OBJECTIVE_NAME), this);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (!all.isLoaded()) continue;
            packetReceiver.sendCustomPacket((TabPacket)new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, OBJECTIVE_NAME, all.getNickname(), this.getValue(all)), this);
        }
    }
}

