/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.alignedplayerlist;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.alignedplayerlist.PlayerView;

public class AlignedPlayerList
extends PlayerList {
    private final Map<TabPlayer, PlayerView> playerViews = new HashMap<TabPlayer, PlayerView>();
    private final byte[] widths = this.loadWidths();

    public AlignedPlayerList() {
        TAB.getInstance().getPlaceholderManager().addUsedPlaceholders(Collections.singletonList("%vanished%"));
    }

    private byte[] loadWidths() {
        byte[] widths = new byte[65536];
        InputStream file = this.getClass().getClassLoader().getResourceAsStream("widths.txt");
        if (file == null) {
            TAB.getInstance().getErrorManager().criticalError("Failed to load widths.txt file. Is it inside the jar? Aligned suffix will not work.", null);
            return widths;
        }
        int characterId = 1;
        for (String line : new BufferedReader(new InputStreamReader(file)).lines().collect(Collectors.toList())) {
            widths[characterId++] = (byte)Float.parseFloat(line);
        }
        Map widthOverrides = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("tablist-name-formatting.character-width-overrides");
        ArrayList<Integer> redundant = new ArrayList<Integer>();
        for (Map.Entry entry : widthOverrides.entrySet()) {
            if (widths[(Integer)entry.getKey()] == ((Integer)entry.getValue()).byteValue()) {
                redundant.add((Integer)entry.getKey());
                continue;
            }
            widths[((Integer)entry.getKey()).intValue()] = ((Integer)entry.getValue()).byteValue();
        }
        redundant.forEach(widthOverrides::remove);
        if (!redundant.isEmpty()) {
            TAB.getInstance().getConfig().save();
        }
        return widths;
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.updateProperties(all);
            this.playerViews.put(all, new PlayerView(this, all));
            if (!this.isDisabled(all.getServer(), all.getWorld())) continue;
            this.addDisabledPlayer(all);
        }
        this.playerViews.values().forEach(PlayerView::load);
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        this.updateProperties(connectedPlayer);
        this.playerViews.put(connectedPlayer, new PlayerView(this, connectedPlayer));
        this.playerViews.values().forEach(v -> v.playerJoin(connectedPlayer));
        if (this.isDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.addDisabledPlayer(connectedPlayer);
            return;
        }
        if (connectedPlayer.getVersion().getMinorVersion() < 8) {
            return;
        }
        Runnable r = () -> {
            this.playerViews.get(connectedPlayer).load();
            this.refresh(connectedPlayer, false);
        };
        r.run();
        if (!this.antiOverrideTabList || !TAB.getInstance().getFeatureManager().isFeatureEnabled("injection") || connectedPlayer.getVersion().getMinorVersion() == 8) {
            TAB.getInstance().getCPUManager().runTaskLater(300, this, "Player Join", r);
        }
    }

    @Override
    public void onQuit(TabPlayer p) {
        super.onQuit(p);
        this.playerViews.values().forEach(v -> v.processPlayerQuit(p));
        this.playerViews.remove(p);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        super.onWorldChange(p, from, to);
        this.playerViews.values().forEach(v -> v.worldChange(p));
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        boolean refresh;
        if (this.isDisabledPlayer(refreshed)) {
            return;
        }
        if (force) {
            this.updateProperties(refreshed);
            refresh = true;
        } else {
            boolean prefix = refreshed.getProperty("tabprefix").update();
            boolean name = refreshed.getProperty("customtabname").update();
            boolean suffix = refreshed.getProperty("tabsuffix").update();
            boolean bl = refresh = prefix || name || suffix;
        }
        if (refresh) {
            this.playerViews.values().forEach(v -> v.updatePlayer(refreshed));
        }
    }

    @Override
    public IChatBaseComponent getTabFormat(TabPlayer p, TabPlayer viewer) {
        PlayerView view = this.playerViews.get(viewer);
        if (view == null) {
            return null;
        }
        return view.formatName(p);
    }

    @Override
    public void onVanishStatusChange(TabPlayer player) {
        this.playerViews.values().forEach(v -> v.onVanishChange(player));
    }

    public byte[] getWidths() {
        return this.widths;
    }
}

