/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.FixedSlot;
import me.neznamy.tab.shared.features.layout.LayoutManager;
import me.neznamy.tab.shared.features.layout.ParentGroup;
import me.neznamy.tab.shared.features.layout.PlayerSlot;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public class Layout
extends TabFeature {
    private final String name;
    private final LayoutManager manager;
    private final Condition displayCondition;
    private final Map<Integer, FixedSlot> fixedSlots;
    private final List<Integer> emptySlots;
    private final List<ParentGroup> groups;
    private final Set<TabPlayer> viewers = Collections.newSetFromMap(new WeakHashMap());

    public Layout(String name, LayoutManager manager, Condition displayCondition, Map<Integer, FixedSlot> fixedSlots, List<Integer> emptySlots, List<ParentGroup> groups) {
        super(manager.getFeatureName(), "Updating player groups");
        this.name = name;
        this.manager = manager;
        this.displayCondition = displayCondition;
        this.fixedSlots = fixedSlots;
        this.emptySlots = emptySlots;
        this.groups = groups;
    }

    public void sendTo(TabPlayer p) {
        if (this.viewers.contains(p)) {
            return;
        }
        this.viewers.add(p);
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        this.groups.forEach(g -> list.addAll(g.getSlots(p)));
        for (FixedSlot slot : this.fixedSlots.values()) {
            p.setProperty(slot, slot.getPropertyName(), slot.getText());
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData("", slot.getId(), slot.getSkin(), slot.getPing(), PacketPlayOutPlayerInfo.EnumGamemode.CREATIVE, IChatBaseComponent.optimizedComponent(p.getProperty(slot.getPropertyName()).updateAndGet()), null));
        }
        Iterator<Object> iterator = this.emptySlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData("", this.manager.getUUID(slot), this.manager.getSkinManager().getDefaultSkin(), this.manager.getEmptySlotPing(), PacketPlayOutPlayerInfo.EnumGamemode.CREATIVE, new IChatBaseComponent(""), null));
        }
        if (p.getVersion().getMinorVersion() < 8 || p.isBedrockPlayer()) {
            return;
        }
        p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, list), this);
    }

    public void removeFrom(TabPlayer p) {
        if (!this.viewers.contains(p)) {
            return;
        }
        this.viewers.remove(p);
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> list = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (UUID id : this.manager.getUuids().values()) {
            list.add(new PacketPlayOutPlayerInfo.PlayerInfoData(id));
        }
        if (p.getVersion().getMinorVersion() < 8 || p.isBedrockPlayer()) {
            return;
        }
        p.sendCustomPacket((TabPacket)new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, list), this);
    }

    public boolean isConditionMet(TabPlayer p) {
        return this.displayCondition == null || this.displayCondition.isMet(p);
    }

    public List<ParentGroup> getGroups() {
        return this.groups;
    }

    public void tick() {
        List<TabPlayer> players = this.manager.getSortedPlayers().keySet().stream().filter(player -> !player.isVanished()).collect(Collectors.toList());
        for (ParentGroup group : this.groups) {
            group.tick(players);
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        this.tick();
    }

    public Set<TabPlayer> getViewers() {
        return this.viewers;
    }

    public boolean containsViewer(TabPlayer viewer) {
        return this.viewers.contains(viewer);
    }

    public LayoutManager getManager() {
        return this.manager;
    }

    public PlayerSlot getSlot(TabPlayer p) {
        for (ParentGroup group : this.groups) {
            if (!group.getPlayers().containsKey(p)) continue;
            return group.getPlayers().get(p);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void onServerChange(TabPlayer player, String from, String to) {
        if (TAB.getInstance().getFeatureManager().isFeatureEnabled("injection")) {
            return;
        }
        if (this.viewers.remove(player)) {
            this.sendTo(player);
        }
    }
}

