/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.nametags.unlimited;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import me.neznamy.tab.api.ArmorStandManager;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.team.UnlimitedNametagManager;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.TabExpansion;
import me.neznamy.tab.shared.features.nametags.NameTag;

public abstract class NameTagX
extends NameTag
implements UnlimitedNametagManager {
    private final boolean markerFor18x = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.use-marker-tag-for-1-8-x-clients", false);
    private final boolean disableOnBoats = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.disable-on-boats", true);
    private final List<String> disabledUnlimitedWorlds = TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.disable-in-worlds", new ArrayList<String>());
    private final List<String> disabledUnlimitedServers = TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.disable-in-servers", new ArrayList<String>());
    private final List<String> dynamicLines = new ArrayList<String>(TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.dynamic-lines", Arrays.asList("abovename", "nametag", "belowname", "another")));
    private final Map<String, Object> staticLines = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("scoreboard-teams.unlimited-nametag-mode.static-lines");
    private final boolean armorStandsAlwaysVisible = TAB.getInstance().getConfiguration().getSecretOption("scoreboard-teams.unlimited-nametag-mode.always-visible", false);
    private final Set<TabPlayer> playersDisabledWithAPI = Collections.newSetFromMap(new WeakHashMap());
    private final Set<TabPlayer> disabledUnlimitedPlayers = Collections.newSetFromMap(new WeakHashMap());
    protected final Map<TabPlayer, ArmorStandManager> armorStandManagerMap = new WeakHashMap<TabPlayer, ArmorStandManager>();
    private final String[] disabledUnlimitedWorldsArray = this.disabledUnlimitedWorlds.toArray(new String[0]);
    private final boolean unlimitedWorldWhitelistMode = this.disabledUnlimitedWorlds.contains("WHITELIST");
    private final String[] disabledUnlimitedServersArray = this.disabledUnlimitedServers.toArray(new String[0]);
    private final boolean unlimitedServerWhitelistMode = this.disabledUnlimitedServers.contains("WHITELIST");
    private final Set<TabPlayer> playersPreviewingNametag = Collections.newSetFromMap(new WeakHashMap());
    private final BiFunction<NameTagX, TabPlayer, ArmorStandManager> armorStandFunction;

    public NameTagX(BiFunction<NameTagX, TabPlayer, ArmorStandManager> armorStandFunction) {
        this.armorStandFunction = armorStandFunction;
        Collections.reverse(this.dynamicLines);
        TAB.getInstance().debug(String.format("Loaded Unlimited NameTag feature with parameters markerFor18x=%s, disableOnBoats=%s, disabledUnlimitedServers=%s, disabledUnlimitedWorlds=%s", this.markerFor18x, this.disableOnBoats, this.disabledUnlimitedServers, this.disabledUnlimitedWorlds));
    }

    public boolean isUnlimitedDisabled(String server, String world) {
        boolean contains = this.contains(this.disabledUnlimitedServersArray, server);
        if (this.unlimitedServerWhitelistMode) {
            boolean bl = contains = !contains;
        }
        if (contains) {
            return true;
        }
        contains = this.contains(this.disabledUnlimitedWorldsArray, world);
        if (this.unlimitedWorldWhitelistMode) {
            contains = !contains;
        }
        return contains;
    }

    public ArmorStandManager getArmorStandManager(TabPlayer player) {
        return this.armorStandManagerMap.get(player);
    }

    public boolean isPlayerDisabled(TabPlayer p) {
        return this.isDisabledPlayer(p) || this.disabledUnlimitedPlayers.contains(p) || this.hasTeamHandlingPaused(p) || this.hasDisabledArmorStands(p);
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            TabExpansion expansion;
            this.updateProperties(all);
            this.armorStandManagerMap.put(all, this.armorStandFunction.apply(this, all));
            if (this.isUnlimitedDisabled(all.getServer(), all.getWorld())) {
                this.disabledUnlimitedPlayers.add(all);
            }
            if ((expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion()) == null) continue;
            expansion.setNameTagPreview(all, false);
        }
        super.load();
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.isUnlimitedDisabled(connectedPlayer.getServer(), connectedPlayer.getWorld())) {
            this.disabledUnlimitedPlayers.add(connectedPlayer);
        }
        super.onJoin(connectedPlayer);
        this.armorStandManagerMap.put(connectedPlayer, this.armorStandFunction.apply(this, connectedPlayer));
        TabExpansion expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion();
        if (expansion != null) {
            expansion.setNameTagPreview(connectedPlayer, false);
        }
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        super.refresh(refreshed, force);
        if (this.isPlayerDisabled(refreshed)) {
            return;
        }
        this.getArmorStandManager(refreshed).refresh(force);
    }

    @Override
    public void unload() {
        super.unload();
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.getArmorStandManager(p).destroy();
        }
    }

    public boolean isMarkerFor18x() {
        return this.markerFor18x;
    }

    public Set<TabPlayer> getDisabledUnlimitedPlayers() {
        return this.disabledUnlimitedPlayers;
    }

    public boolean isDisableOnBoats() {
        return this.disableOnBoats;
    }

    public List<String> getDynamicLines() {
        return this.dynamicLines;
    }

    public Map<String, Object> getStaticLines() {
        return this.staticLines;
    }

    public List<String> getDisabledUnlimitedWorlds() {
        return this.disabledUnlimitedWorlds;
    }

    public void toggleNametagPreview(TabPlayer player) {
        if (this.playersPreviewingNametag.contains(player)) {
            this.setNameTagPreview(player, false);
            player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNametagPreviewOff(), true);
            this.playersPreviewingNametag.remove(player);
        } else {
            this.setNameTagPreview(player, true);
            player.sendMessage(TAB.getInstance().getConfiguration().getMessages().getNametagPreviewOn(), true);
            this.playersPreviewingNametag.add(player);
        }
        TabExpansion expansion = TAB.getInstance().getPlaceholderManager().getTabExpansion();
        if (expansion != null) {
            expansion.setNameTagPreview(player, this.isPreviewingNametag(player));
        }
    }

    public boolean isPreviewingNametag(TabPlayer player) {
        return this.playersPreviewingNametag.contains(player);
    }

    @Override
    public void onWorldChange(TabPlayer p, String from, String to) {
        super.onWorldChange(p, from, to);
        if (this.isUnlimitedDisabled(p.getServer(), to)) {
            if (this.getDisabledUnlimitedPlayers().add(p)) {
                this.updateTeamData(p);
            }
        } else {
            if (this.getDisabledUnlimitedPlayers().remove(p)) {
                this.updateTeamData(p);
            }
            this.getArmorStandManager(p).refresh(true);
        }
    }

    @Override
    public boolean updateProperties(TabPlayer p) {
        boolean changed = super.updateProperties(p);
        if (p.loadPropertyFromConfig(this, "customtagname", p.getName())) {
            changed = true;
        }
        if (p.setProperty(this, "nametag", p.getProperty("tagprefix").getCurrentRawValue() + p.getProperty("customtagname").getCurrentRawValue() + p.getProperty("tagsuffix").getCurrentRawValue())) {
            changed = true;
        }
        for (String property : this.dynamicLines) {
            if (property.equals("nametag") || !p.loadPropertyFromConfig(this, property)) continue;
            changed = true;
        }
        for (String property : this.staticLines.keySet()) {
            if (property.equals("nametag") || !p.loadPropertyFromConfig(this, property)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean getTeamVisibility(TabPlayer p, TabPlayer viewer) {
        if (p.hasInvisibilityPotion()) {
            return false;
        }
        if (this.playersWithInvisibleNameTagView.contains(viewer)) {
            return false;
        }
        return this.isOnBoat(p) || this.isPlayerDisabled(p);
    }

    @Override
    public String getFeatureName() {
        return "Unlimited NameTags";
    }

    public List<String> getDisabledUnlimitedServers() {
        return this.disabledUnlimitedServers;
    }

    public boolean isArmorStandsAlwaysVisible() {
        return this.armorStandsAlwaysVisible;
    }

    public abstract boolean isOnBoat(TabPlayer var1);

    public abstract void setNameTagPreview(TabPlayer var1, boolean var2);

    public abstract void resumeArmorStands(TabPlayer var1);

    public abstract void pauseArmorStands(TabPlayer var1);

    public abstract void updateNameTagVisibilityView(TabPlayer var1);

    @Override
    public void hideNametag(TabPlayer player, TabPlayer viewer) {
        if (((List)this.hiddenNameTagFor.get(player)).contains(viewer)) {
            return;
        }
        ((List)this.hiddenNameTagFor.get(player)).add(viewer);
        this.updateTeamData(player, viewer);
        this.pauseArmorStands(player);
    }

    @Override
    public void showNametag(TabPlayer player, TabPlayer viewer) {
        if (!((List)this.hiddenNameTagFor.get(player)).contains(viewer)) {
            return;
        }
        ((List)this.hiddenNameTagFor.get(player)).remove(viewer);
        this.updateTeamData(player, viewer);
        this.resumeArmorStands(player);
    }

    @Override
    public void disableArmorStands(TabPlayer player) {
        Preconditions.checkLoaded(player);
        if (this.playersDisabledWithAPI.contains(player)) {
            return;
        }
        this.playersDisabledWithAPI.add(player);
        this.pauseArmorStands(player);
        this.updateTeamData(player);
    }

    @Override
    public void enableArmorStands(TabPlayer player) {
        Preconditions.checkLoaded(player);
        if (!this.playersDisabledWithAPI.contains(player)) {
            return;
        }
        this.playersDisabledWithAPI.remove(player);
        this.resumeArmorStands(player);
        this.updateTeamData(player);
    }

    @Override
    public boolean hasDisabledArmorStands(TabPlayer player) {
        return this.playersDisabledWithAPI.contains(player);
    }

    @Override
    public void setName(TabPlayer player, String customName) {
        Preconditions.checkLoaded(player);
        player.getProperty("customtagname").setTemporaryValue(customName);
        this.rebuildNameTagLine(player);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void setLine(TabPlayer player, String line, String value) {
        Preconditions.checkLoaded(player);
        if (!this.getDefinedLines().contains(line)) {
            throw new IllegalArgumentException("\"" + line + "\" is not a defined line. Defined lines: " + this.getDefinedLines());
        }
        player.getProperty(line).setTemporaryValue(value);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void resetName(TabPlayer player) {
        Preconditions.checkLoaded(player);
        player.getProperty("customtagname").setTemporaryValue(null);
        this.rebuildNameTagLine(player);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void resetLine(TabPlayer player, String line) {
        Preconditions.checkLoaded(player);
        player.getProperty(line).setTemporaryValue(null);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public String getCustomName(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("customtagname").getTemporaryValue();
    }

    @Override
    public String getCustomLineValue(TabPlayer player, String line) {
        Preconditions.checkLoaded(player);
        return player.getProperty(line).getTemporaryValue();
    }

    @Override
    public String getOriginalName(TabPlayer player) {
        Preconditions.checkLoaded(player);
        return player.getProperty("customtagname").getOriginalRawValue();
    }

    @Override
    public String getOriginalLineValue(TabPlayer player, String line) {
        Preconditions.checkLoaded(player);
        return player.getProperty(line).getOriginalRawValue();
    }

    @Override
    public List<String> getDefinedLines() {
        ArrayList<String> lines = new ArrayList<String>(this.dynamicLines);
        lines.addAll(this.staticLines.keySet());
        return lines;
    }

    private void rebuildNameTagLine(TabPlayer player) {
        player.setProperty(this, "nametag", player.getProperty("tagprefix").getCurrentRawValue() + player.getProperty("customtagname").getCurrentRawValue() + player.getProperty("tagsuffix").getCurrentRawValue());
    }

    @Override
    public void setPrefix(TabPlayer player, String prefix) {
        Preconditions.checkLoaded(player);
        super.setPrefix(player, prefix);
        this.rebuildNameTagLine(player);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void setSuffix(TabPlayer player, String suffix) {
        Preconditions.checkLoaded(player);
        super.setSuffix(player, suffix);
        this.rebuildNameTagLine(player);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void resetPrefix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        super.resetPrefix(player);
        this.rebuildNameTagLine(player);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void resetSuffix(TabPlayer player) {
        Preconditions.checkLoaded(player);
        super.resetSuffix(player);
        this.rebuildNameTagLine(player);
        this.getArmorStandManager(player).refresh(true);
    }

    @Override
    public void pauseTeamHandling(TabPlayer player) {
        Preconditions.checkLoaded(player);
        if (this.teamHandlingPaused.contains(player)) {
            return;
        }
        if (!this.isDisabledPlayer(player)) {
            this.unregisterTeam(player);
        }
        this.teamHandlingPaused.add(player);
        this.pauseArmorStands(player);
    }

    @Override
    public void resumeTeamHandling(TabPlayer player) {
        Preconditions.checkLoaded(player);
        if (!this.teamHandlingPaused.contains(player)) {
            return;
        }
        this.teamHandlingPaused.remove(player);
        if (!this.isDisabledPlayer(player)) {
            this.registerTeam(player);
        }
        this.resumeArmorStands(player);
    }

    @Override
    public void toggleNameTagVisibilityView(TabPlayer player, boolean sendToggleMessage) {
        super.toggleNameTagVisibilityView(player, sendToggleMessage);
        this.updateNameTagVisibilityView(player);
    }
}

