/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis;

import java.util.Collections;
import java.util.UUID;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.Skin;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.libs.org.json.simple.JSONObject;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.redis.RedisSupport;

public class RedisPlayer {
    private RedisSupport redis;
    private boolean disabledPlayerList;
    private boolean disabledNameTags;
    private UUID uniqueId;
    private String name;
    private String nickname;
    private String server;
    private String tabFormat;
    private String teamName;
    private boolean vanished;
    private Skin skin;
    private String tagPrefix;
    private String tagSuffix;
    private boolean nameVisibility;
    private String belowName;
    private String yellowNumber;
    private boolean staff;

    private RedisPlayer() {
    }

    public static RedisPlayer fromJson(RedisSupport redis, JSONObject json) {
        RedisPlayer player = new RedisPlayer();
        player.redis = redis;
        player.uniqueId = UUID.fromString((String)json.get("UUID"));
        player.nickname = player.name = (String)json.get("name");
        player.server = (String)json.get("server");
        player.tabFormat = (String)json.get("tabformat");
        String team = (String)json.get("teamname");
        player.teamName = RedisPlayer.checkTeamName(redis, team.substring(0, team.length() - 1), 65);
        player.vanished = (Boolean)json.get("vanished");
        String skinValue = (String)json.get("skin-value");
        if (skinValue != null) {
            player.skin = new Skin(skinValue, (String)json.get("skin-signature"));
        }
        player.tagPrefix = (String)json.get("tagprefix");
        player.tagSuffix = (String)json.get("tagsuffix");
        player.nameVisibility = (Boolean)json.get("namevisibility");
        player.belowName = (String)json.get("belowname");
        player.yellowNumber = (String)json.get("yellow-number");
        player.staff = (Boolean)json.get("staff");
        player.disabledPlayerList = redis.getPlayerList() == null || redis.getPlayerList().isDisabled(player.server, null);
        player.disabledNameTags = redis.getNameTags() == null || redis.getNameTags().isDisabled(player.server, null);
        return player;
    }

    private static String checkTeamName(RedisSupport redis, String currentName15, int id) {
        String potentialTeamName = currentName15 + (char)id;
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all.getTeamName() == null || !all.getTeamName().equals(potentialTeamName)) continue;
            return RedisPlayer.checkTeamName(redis, currentName15, id + 1);
        }
        for (RedisPlayer all : redis.getRedisPlayers().values()) {
            if (all.getTeamName() == null || !all.getTeamName().equals(potentialTeamName)) continue;
            return RedisPlayer.checkTeamName(redis, currentName15, id + 1);
        }
        return potentialTeamName;
    }

    public static JSONObject toJson(RedisSupport redis, TabPlayer p) {
        JSONObject json = new JSONObject();
        json.put("action", "join");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("name", p.getName());
        json.put("server", p.getServer());
        if (redis.getPlayerList() != null) {
            json.put("tabformat", p.getProperty("tabprefix").get() + p.getProperty("customtabname").get() + p.getProperty("tabsuffix").get());
        }
        if (p.getProperty("tagprefix") != null) {
            json.put("tagprefix", p.getProperty("tagprefix").get());
            json.put("tagsuffix", p.getProperty("tagsuffix").get());
            json.put("namevisibility", redis.getNameTags().getTeamVisibility(p, p));
        } else {
            json.put("tagprefix", "");
            json.put("tagsuffix", "");
            json.put("namevisibility", true);
        }
        if (p.getProperty("belowname-number") != null) {
            json.put("belowname", p.getProperty("belowname-number").get());
        }
        if (p.getProperty("yellow-number") != null) {
            json.put("yellow-number", p.getProperty("yellow-number").get());
        }
        json.put("teamname", p.getTeamName());
        json.put("vanished", p.isVanished());
        json.put("staff", p.hasPermission("tab.staff"));
        if (p.getSkin() != null) {
            json.put("skin-value", p.getSkin().getValue());
            json.put("skin-signature", p.getSkin().getSignature());
        }
        return json;
    }

    public PacketPlayOutPlayerInfo getAddPacket() {
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new PacketPlayOutPlayerInfo.PlayerInfoData(this.nickname, this.uniqueId, this.skin, 0, PacketPlayOutPlayerInfo.EnumGamemode.SURVIVAL, this.disabledPlayerList ? null : IChatBaseComponent.optimizedComponent(this.tabFormat), null));
    }

    public PacketPlayOutPlayerInfo getUpdatePacket() {
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME, new PacketPlayOutPlayerInfo.PlayerInfoData(this.uniqueId, this.disabledPlayerList ? null : IChatBaseComponent.optimizedComponent(this.tabFormat)));
    }

    public PacketPlayOutPlayerInfo getRemovePacket() {
        PacketPlayOutPlayerInfo.PlayerInfoData data = new PacketPlayOutPlayerInfo.PlayerInfoData(this.uniqueId);
        data.setName(this.nickname);
        return new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, data);
    }

    public PacketPlayOutScoreboardTeam getRegisterTeamPacket() {
        if (this.disabledNameTags) {
            return null;
        }
        return new PacketPlayOutScoreboardTeam(this.teamName, this.tagPrefix, this.tagSuffix, this.nameVisibility ? "always" : "never", "always", Collections.singletonList(this.nickname), 2);
    }

    public PacketPlayOutScoreboardTeam getUpdateTeamPacket() {
        if (this.disabledNameTags) {
            return null;
        }
        return new PacketPlayOutScoreboardTeam(this.teamName, this.tagPrefix, this.tagSuffix, this.nameVisibility ? "always" : "never", "always", 2);
    }

    public PacketPlayOutScoreboardTeam getUnregisterTeamPacket() {
        if (this.disabledNameTags) {
            return null;
        }
        return new PacketPlayOutScoreboardTeam(this.teamName);
    }

    public PacketPlayOutScoreboardScore getBelowNameUpdatePacket() {
        if (this.belowName == null) {
            return null;
        }
        return new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-BelowName", this.nickname, TAB.getInstance().getErrorManager().parseInteger(this.belowName, 0));
    }

    public PacketPlayOutScoreboardScore getYellowNumberUpdatePacket() {
        if (this.yellowNumber == null) {
            return null;
        }
        return new PacketPlayOutScoreboardScore(PacketPlayOutScoreboardScore.Action.CHANGE, "TAB-YellowNumber", this.nickname, TAB.getInstance().getErrorManager().parseInteger(this.yellowNumber, 0));
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        block10: {
            block11: {
                this.server = server;
                if (this.redis.getPlayerList() != null) {
                    if (this.disabledPlayerList) {
                        if (!this.redis.getPlayerList().isDisabled(server, null)) {
                            this.disabledPlayerList = false;
                            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                                if (all.getVersion().getMinorVersion() < 8) continue;
                                all.sendCustomPacket((TabPacket)this.getUpdatePacket(), this.redis);
                            }
                        }
                    } else if (this.redis.getPlayerList().isDisabled(server, null)) {
                        this.disabledPlayerList = true;
                        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                            if (all.getVersion().getMinorVersion() < 8) continue;
                            all.sendCustomPacket((TabPacket)this.getUpdatePacket(), this.redis);
                        }
                    }
                }
                if (this.redis.getNameTags() == null) break block10;
                if (!this.disabledNameTags) break block11;
                if (this.redis.getNameTags().isDisabled(server, null)) break block10;
                this.disabledNameTags = false;
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    all.sendCustomPacket((TabPacket)this.getRegisterTeamPacket(), this.redis);
                }
                break block10;
            }
            if (this.redis.getNameTags().isDisabled(server, null)) {
                this.disabledNameTags = true;
                for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                    all.sendCustomPacket((TabPacket)this.getUnregisterTeamPacket(), this.redis);
                }
            }
        }
    }

    public boolean isVanished() {
        return this.vanished;
    }

    public String getName() {
        return this.name;
    }

    public String getNickName() {
        return this.nickname;
    }

    public void setNickName(String nickname) {
        this.nickname = nickname;
    }

    public String getTabFormat() {
        return this.tabFormat;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public void setTabFormat(String format) {
        this.tabFormat = format;
    }

    public void setTagPrefix(String tagprefix) {
        this.tagPrefix = tagprefix;
    }

    public void setTagSuffix(String tagsuffix) {
        this.tagSuffix = tagsuffix;
    }

    public void setBelowName(String belowname) {
        this.belowName = belowname;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setYellowNumber(String yellowNumber) {
        this.yellowNumber = yellowNumber;
    }

    public boolean isStaff() {
        return this.staff;
    }

    public boolean hasDisabledPlayerlist() {
        return this.disabledPlayerList;
    }

    public void setTeamName(String teamName) {
        this.teamName = RedisPlayer.checkTeamName(this.redis, teamName.substring(0, teamName.length() - 1), 65);
    }
}

