/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.sorting.types;

import java.util.LinkedHashMap;
import java.util.Locale;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.features.sorting.Sorting;
import me.neznamy.tab.shared.features.sorting.types.SortingType;

public class Placeholder
extends SortingType {
    private final LinkedHashMap<String, String> sortingMap;

    public Placeholder(Sorting sorting, String options) {
        super(sorting, Placeholder.getPlaceholder(options));
        String[] args = options.split(":");
        this.sortingMap = args.length > 1 ? this.convertSortingElements(args[args.length - 1].split(",")) : new LinkedHashMap();
    }

    private static String getPlaceholder(String options) {
        String[] args = options.split(":");
        if (args.length == 1) {
            return args[0];
        }
        return options.substring(0, options.length() - args[args.length - 1].length() - 1);
    }

    @Override
    public String getChars(ITabPlayer p) {
        String output = EnumChatFormat.color(this.setPlaceholders(p));
        p.setTeamNameNote(p.getTeamNameNote() + this.sortingPlaceholder + " returned \"" + output + "\"");
        String sortingValue = this.sortingMap.get(output.toLowerCase(Locale.US));
        if (sortingValue == null) {
            sortingValue = String.valueOf(this.sortingMap.size() + 1);
            p.setTeamNameNote(p.getTeamNameNote() + "&c (not in list)&r. ");
        } else {
            p.setTeamNameNote(p.getTeamNameNote() + "&r (#" + Integer.parseInt(sortingValue) + " in list). &r");
        }
        return sortingValue;
    }

    public String toString() {
        return "PLACEHOLDER";
    }
}

