/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.sorting.types;

import java.util.Collections;
import java.util.LinkedHashMap;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.sorting.Sorting;

public abstract class SortingType {
    protected final int DEFAULT_NUMBER = 5000000;
    protected String sortingPlaceholder;

    protected SortingType() {
    }

    protected SortingType(Sorting sorting, String sortingPlaceholder) {
        if (!sortingPlaceholder.startsWith("%") || !sortingPlaceholder.endsWith("%")) {
            TAB.getInstance().getErrorManager().startupWarn("\"" + sortingPlaceholder + "\" is not a valid placeholder for " + this + " sorting type");
        } else {
            sorting.addUsedPlaceholders(Collections.singletonList(sortingPlaceholder));
            this.sortingPlaceholder = sortingPlaceholder;
        }
    }

    protected String setPlaceholders(TabPlayer player) {
        if (this.sortingPlaceholder == null) {
            return "";
        }
        return TAB.getInstance().getPlaceholderManager().getPlaceholder(this.sortingPlaceholder).set(this.sortingPlaceholder, player);
    }

    protected LinkedHashMap<String, String> convertSortingElements(String[] elements) {
        LinkedHashMap<String, String> sortedGroups = new LinkedHashMap<String, String>();
        int index = 1;
        int charCount = String.valueOf(elements.length).length() + 1;
        for (String element : elements) {
            StringBuilder sb = new StringBuilder();
            sb.append(index);
            while (sb.length() < charCount) {
                sb.insert(0, "0");
            }
            for (String element0 : element.split("\\|")) {
                while (element0.startsWith(" ")) {
                    element0 = element0.substring(1);
                }
                while (element0.endsWith(" ")) {
                    element0 = element0.substring(0, element0.length() - 1);
                }
                sortedGroups.put(EnumChatFormat.color(element0.toLowerCase()), sb.toString());
            }
            ++index;
        }
        return sortedGroups;
    }

    public abstract String getChars(ITabPlayer var1);
}

