/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.shared.TAB;

public class PlaceholderReplacementPattern {
    private final Map<String, String> replacements = new HashMap<String, String>();
    private final Map<float[], String> numberIntervals = new HashMap<float[], String>();
    private final Set<String> nestedPlaceholders = new HashSet<String>();

    public PlaceholderReplacementPattern(String identifier, Map<Object, Object> map) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue()).replace(identifier, "%value%");
            this.replacements.put(EnumChatFormat.color(key), EnumChatFormat.color(value));
            this.replacements.put(key, EnumChatFormat.color(value));
            this.nestedPlaceholders.addAll(TAB.getInstance().getPlaceholderManager().detectPlaceholders(value));
            this.nestedPlaceholders.remove("%value%");
            if ("true".equals(key)) {
                this.replacements.put("yes", value);
                continue;
            }
            if ("false".equals(key)) {
                this.replacements.put("no", value);
                continue;
            }
            if (!key.contains("-")) continue;
            try {
                this.numberIntervals.put(new float[]{Float.parseFloat(key.split("-")[0]), Float.parseFloat(key.split("-")[1])}, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.numberIntervals.put(new float[]{Float.parseFloat(key.split("~")[0]), Float.parseFloat(key.split("~")[1])}, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Set<String> getNestedPlaceholders() {
        return this.nestedPlaceholders;
    }

    public String findReplacement(String output) {
        String replacement = this.findReplacement0(output);
        if (replacement == null) {
            return "";
        }
        if (replacement.contains("%value%")) {
            replacement = replacement.replace("%value%", output);
        }
        return replacement;
    }

    private String findReplacement0(String output) {
        if (this.replacements.isEmpty()) {
            return output;
        }
        if (this.replacements.containsKey(output)) {
            return this.replacements.get(output);
        }
        if (this.numberIntervals.size() > 0) {
            try {
                String cleanValue = output.contains(",") ? output.replace(",", "") : output;
                float value = Float.parseFloat(cleanValue);
                for (float[] interval : this.numberIntervals.keySet()) {
                    if (!(interval[0] <= value) || !(value <= interval[1])) continue;
                    return this.numberIntervals.get(interval);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.replacements.containsKey("else")) {
            return this.replacements.get("else");
        }
        return output;
    }
}

