/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.neznamy.tab.api.TabConstants;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.placeholders.Animation;
import me.neznamy.tab.shared.placeholders.PlaceholderRegistry;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.conditions.Condition;

public class UniversalPlaceholderRegistry
implements PlaceholderRegistry {
    private final DecimalFormat decimal2 = new DecimalFormat("#.##");

    @Override
    public void registerPlaceholders(PlaceholderManager manager) {
        manager.registerServerPlaceholder("%%", -1, () -> "%");
        manager.registerPlayerPlaceholder("%group%", -1, TabPlayer::getGroup);
        manager.registerPlayerPlaceholder("%vanished%", 1000, TabPlayer::isVanished);
        manager.registerPlayerPlaceholder("%world%", -1, TabPlayer::getWorld);
        manager.registerPlayerPlaceholder("%worldonline%", 1000, p -> Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(all -> p.getWorld().equals(all.getWorld()) && !all.isVanished()).count());
        manager.registerPlayerPlaceholder("%server%", -1, TabPlayer::getServer);
        manager.registerPlayerPlaceholder("%serveronline%", 1000, p -> Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(all -> p.getServer().equals(all.getServer()) && !all.isVanished()).count());
        manager.registerPlayerPlaceholder("%player%", -1, TabPlayer::getName);
        double timeOffset = TAB.getInstance().getConfiguration().getConfig().getDouble("placeholders.time-offset", 0.0);
        SimpleDateFormat timeFormat = this.createDateFormat(TAB.getInstance().getConfiguration().getConfig().getString("placeholders.time-format", "[HH:mm:ss / h:mm a]"), "[HH:mm:ss / h:mm a]");
        manager.registerServerPlaceholder("%time%", 500, () -> timeFormat.format(new Date(System.currentTimeMillis() + (long)((int)(timeOffset * 3600000.0)))));
        SimpleDateFormat dateFormat = this.createDateFormat(TAB.getInstance().getConfiguration().getConfig().getString("placeholders.date-format", "dd.MM.yyyy"), "dd.MM.yyyy");
        manager.registerServerPlaceholder("%date%", 60000, () -> dateFormat.format(new Date(System.currentTimeMillis() + (long)((int)(timeOffset * 3600000.0)))));
        manager.registerPlayerPlaceholder("%ping%", 500, TabPlayer::getPing);
        manager.registerPlayerPlaceholder("%player-version%", -1, p -> p.getVersion().getFriendlyName());
        manager.registerPlayerPlaceholder("%player-version-id%", -1, p -> p.getVersion().getNetworkId());
        manager.registerServerPlaceholder("%memory-used%", 200, () -> (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L));
        manager.registerServerPlaceholder("%memory-max%", -1, () -> (int)(Runtime.getRuntime().maxMemory() / 0x100000L));
        manager.registerServerPlaceholder("%memory-used-gb%", 200, () -> this.decimal2.format((float)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0f / 1024.0f / 1024.0f));
        manager.registerServerPlaceholder("%memory-max-gb%", -1, () -> this.decimal2.format((float)Runtime.getRuntime().maxMemory() / 1024.0f / 1024.0f / 1024.0f));
        manager.registerServerPlaceholder("%online%", 1000, () -> Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(all -> !all.isVanished()).count());
        manager.registerServerPlaceholder("%staffonline%", 2000, () -> Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(all -> all.hasPermission("tab.staff") && !all.isVanished()).count());
        manager.registerServerPlaceholder("%nonstaffonline%", 2000, () -> Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(all -> !all.hasPermission("tab.staff") && !all.isVanished()).count());
        PermissionPlugin plugin = TAB.getInstance().getGroupManager().getPlugin();
        if (plugin instanceof LuckPerms) {
            manager.registerPlayerPlaceholder("%luckperms-prefix%", 1000, ((LuckPerms)plugin)::getPrefix);
            manager.registerPlayerPlaceholder("%luckperms-suffix%", 1000, ((LuckPerms)plugin)::getSuffix);
        }
        for (String s : TAB.getInstance().getConfiguration().getAnimationFile().getValues().keySet()) {
            Animation a = new Animation(s.toString(), TAB.getInstance().getConfiguration().getAnimationFile().getStringList(s + ".texts"), TAB.getInstance().getConfiguration().getAnimationFile().getInt(s + ".change-interval", 0));
            final List<String> nested = Arrays.asList(a.getNestedPlaceholders());
            ((PlaceholderManagerImpl)manager).registerPlaceholder(new PlayerPlaceholderImpl(TabConstants.Placeholder.animation(a.getName()), a.getRefresh(), p -> a.getMessage()){

                @Override
                public List<String> getNestedPlaceholders(String output) {
                    return nested;
                }
            });
        }
        Condition.clearConditions();
        Map conditions = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("conditions");
        for (Map.Entry condition : conditions.entrySet()) {
            List list = (List)((Map)condition.getValue()).get("conditions");
            String type = String.valueOf(((Map)condition.getValue()).get("type"));
            String yes = ((Object)((Map)condition.getValue()).getOrDefault(true, true)).toString();
            String no = ((Object)((Map)condition.getValue()).getOrDefault(false, false)).toString();
            Condition c = new Condition(!"OR".equals(type), (String)condition.getKey(), list, yes, no);
            manager.registerPlayerPlaceholder(TabConstants.Placeholder.condition(c.getName()), c.getRefresh(), c::getText);
        }
    }

    private SimpleDateFormat createDateFormat(String value, String defaultValue) {
        try {
            return new SimpleDateFormat(value, Locale.ENGLISH);
        }
        catch (IllegalArgumentException e) {
            TAB.getInstance().getErrorManager().startupWarn("Format \"" + value + "\" is not a valid date/time format. Did you try to use color codes?");
            return new SimpleDateFormat(defaultValue);
        }
    }
}

