/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders.conditions;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.neznamy.tab.api.TabConstants;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;
import me.neznamy.tab.shared.placeholders.conditions.simple.ContainsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.EqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.LessThanCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.LessThanOrEqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.MoreThanCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.MoreThanOrEqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.NotEqualsCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.PermissionCondition;
import me.neznamy.tab.shared.placeholders.conditions.simple.SimpleCondition;

public class Condition {
    private static Map<String, Condition> registeredConditions = new HashMap<String, Condition>();
    private static final Map<String, Function<String, SimpleCondition>> conditionTypes = new LinkedHashMap<String, Function<String, SimpleCondition>>(){
        {
            this.put("permission:", PermissionCondition::new);
            this.put("<-", ContainsCondition::new);
            this.put(">=", MoreThanOrEqualsCondition::new);
            this.put(">", MoreThanCondition::new);
            this.put("<=", LessThanOrEqualsCondition::new);
            this.put("<", LessThanCondition::new);
            this.put("!=", NotEqualsCondition::new);
            this.put("=", EqualsCondition::new);
        }
    };
    private final String name;
    protected SimpleCondition[] subConditions;
    private final boolean type;
    private final String yes;
    private final String no;
    private int refresh = -1;

    public Condition(boolean type, String name, List<String> conditions, String yes, String no) {
        this.type = type;
        this.name = name;
        this.yes = yes;
        this.no = no;
        if (conditions == null) {
            TAB.getInstance().getErrorManager().startupWarn("Condition \"" + name + "\" is missing \"conditions\" section.");
            return;
        }
        ArrayList<SimpleCondition> list = new ArrayList<SimpleCondition>();
        for (String line : conditions) {
            SimpleCondition condition = SimpleCondition.compile(line);
            if (condition != null) {
                list.add(condition);
                continue;
            }
            TAB.getInstance().getErrorManager().startupWarn("\"" + line + "\" is not a defined condition nor a condition pattern");
        }
        this.subConditions = list.toArray(new SimpleCondition[0]);
        PlaceholderManagerImpl pm = TAB.getInstance().getPlaceholderManager();
        ArrayList<String> placeholdersInConditions = new ArrayList<String>();
        for (String subCondition : conditions) {
            if (subCondition.startsWith("permission:")) {
                if (this.refresh <= 1000 && this.refresh != -1) continue;
                this.refresh = 1000;
                continue;
            }
            placeholdersInConditions.addAll(pm.detectPlaceholders(subCondition));
        }
        placeholdersInConditions.addAll(pm.detectPlaceholders(yes));
        placeholdersInConditions.addAll(pm.detectPlaceholders(no));
        for (String placeholder : placeholdersInConditions) {
            TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder).addParent(TabConstants.Placeholder.condition(name));
            TabPlaceholder pl = TAB.getInstance().getPlaceholderManager().getPlaceholder(placeholder);
            if (pl.getRefresh() >= this.refresh || pl.getRefresh() == -1) continue;
            this.refresh = pl.getRefresh();
        }
        pm.addUsedPlaceholders(placeholdersInConditions);
        registeredConditions.put(name, this);
    }

    public int getRefresh() {
        return this.refresh;
    }

    public String getName() {
        return this.name;
    }

    public String getText(TabPlayer p) {
        return this.isMet(p) ? this.yes : this.no;
    }

    public boolean isMet(TabPlayer p) {
        if (this.type) {
            for (SimpleCondition condition : this.subConditions) {
                if (condition.isMet(p)) continue;
                return false;
            }
            return true;
        }
        for (SimpleCondition condition : this.subConditions) {
            if (!condition.isMet(p)) continue;
            return true;
        }
        return false;
    }

    public static Condition getCondition(String string) {
        if (string == null) {
            return null;
        }
        if (registeredConditions.containsKey(string)) {
            return registeredConditions.get(string);
        }
        Condition c = new Condition(true, "AnonymousCondition[" + string + "]", Lists.newArrayList((Object[])string.split(";")), "true", "false");
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(TabConstants.Placeholder.condition(c.getName()), c.getRefresh(), c::getText);
        return c;
    }

    public static void clearConditions() {
        registeredConditions = new HashMap<String, Condition>();
    }

    public static Map<String, Function<String, SimpleCondition>> getConditionTypes() {
        return conditionTypes;
    }
}

