/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.api.placeholder.RelationalPlaceholder;
import me.neznamy.tab.api.placeholder.ServerPlaceholder;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.permission.VaultBridge;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;

public class PluginMessageHandler {
    public void onPluginMessage(UUID uuid, byte[] bytes) {
        TAB.getInstance().getCPUManager().runMeasuredTask("Plugin message handling", "PluginMessageEvent", () -> {
            ProxyTabPlayer player = (ProxyTabPlayer)TAB.getInstance().getPlayer(uuid);
            if (player == null) {
                return;
            }
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])bytes);
            String subChannel = in.readUTF();
            if ("Placeholder".equals(subChannel)) {
                TabPlaceholder placeholder = TAB.getInstance().getPlaceholderManager().getPlaceholder(in.readUTF());
                if (placeholder instanceof RelationalPlaceholder) {
                    ((RelationalPlaceholder)((Object)placeholder)).updateValue(player, TAB.getInstance().getPlayer(in.readUTF()), in.readUTF());
                } else {
                    ((PlayerPlaceholder)((Object)placeholder)).updateValue(player, in.readUTF());
                }
            }
            if ("Vanished".equals(subChannel)) {
                player.setVanished(in.readBoolean());
                TAB.getInstance().getFeatureManager().onVanishStatusChange(player);
                ((PlayerPlaceholderImpl)TAB.getInstance().getPlaceholderManager().getPlaceholder("%vanished%")).updateValue(player, player.isVanished());
            }
            if ("Disguised".equals(subChannel)) {
                player.setDisguised(in.readBoolean());
            }
            if ("Invisible".equals(subChannel)) {
                player.setInvisible(in.readBoolean());
            }
            if ("World".equals(subChannel)) {
                TAB.getInstance().getFeatureManager().onWorldChange(player.getUniqueId(), in.readUTF());
            }
            if ("Group".equals(subChannel)) {
                player.setGroup(in.readUTF());
            }
            if ("Boat".equals(subChannel)) {
                player.setOnBoat(in.readBoolean());
            }
            if ("Permission".equals(subChannel)) {
                player.setHasPermission(in.readUTF(), in.readBoolean());
            }
            if ("PlayerJoinResponse".equals(subChannel)) {
                TAB.getInstance().getFeatureManager().onWorldChange(player.getUniqueId(), in.readUTF());
                if (TAB.getInstance().getGroupManager().getPlugin() instanceof VaultBridge && !TAB.getInstance().getGroupManager().isGroupsByPermissions()) {
                    player.setGroup(in.readUTF());
                }
                player.setVanished(false);
                player.setDisguised(false);
                player.setInvisible(false);
                int placeholderCount = in.readInt();
                for (int i = 0; i < placeholderCount; ++i) {
                    String identifier = in.readUTF();
                    if (identifier.startsWith("%rel_")) {
                        int playerCount = in.readInt();
                        for (int j = 0; j < playerCount; ++j) {
                            ((RelationalPlaceholder)((Object)TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier))).updateValue(player, TAB.getInstance().getPlayer(in.readUTF()), in.readUTF());
                        }
                        continue;
                    }
                    TabPlaceholder pl = TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier);
                    if (pl instanceof PlayerPlaceholder) {
                        ((PlayerPlaceholder)((Object)pl)).updateValue(player, in.readUTF());
                        continue;
                    }
                    ((ServerPlaceholder)((Object)pl)).updateValue(in.readUTF());
                }
            }
            if ("PlaceholderError".equals(subChannel)) {
                String message = in.readUTF();
                int count = in.readInt();
                ArrayList<String> stack = new ArrayList<String>();
                for (int i = 0; i < count; ++i) {
                    stack.add(in.readUTF());
                }
                TAB.getInstance().getErrorManager().placeholderError(message, stack);
            }
            if ("RegisterPlaceholder".equals(subChannel)) {
                TAB.getInstance().getPlaceholderManager().addUsedPlaceholders(Collections.singletonList(in.readUTF()));
            }
        });
    }

    public void sendMessage(TabPlayer player, Object ... args) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (Object arg : args) {
            this.writeObject(out, arg);
        }
        ((ProxyTabPlayer)player).sendPluginMessage(out.toByteArray());
    }

    private void writeObject(ByteArrayDataOutput out, Object value) {
        Preconditions.checkNotNull(value, "value to write");
        if (value instanceof String) {
            out.writeUTF((String)value);
        } else if (value instanceof Boolean) {
            out.writeBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            out.writeInt(((Integer)value).intValue());
        } else if (value instanceof Double) {
            out.writeDouble(((Double)value).doubleValue());
        } else {
            throw new IllegalArgumentException("Unhandled message data type " + value.getClass().getName());
        }
    }
}

