/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.proxy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.shared.Platform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerList;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.nametags.unlimited.ProxyNameTagX;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.permission.VaultBridge;
import me.neznamy.tab.shared.placeholders.UniversalPlaceholderRegistry;
import me.neznamy.tab.shared.proxy.PluginMessageHandler;
import me.neznamy.tab.shared.proxy.ProxyTabExpansion;

public abstract class ProxyPlatform
extends Platform {
    protected final PluginMessageHandler plm = new PluginMessageHandler();
    private final Map<String, Integer> bridgePlaceholders = new ConcurrentHashMap<String, Integer>();

    protected ProxyPlatform(PacketBuilder packetBuilder) {
        super(packetBuilder);
    }

    public PluginMessageHandler getPluginMessageHandler() {
        return this.plm;
    }

    public Map<String, Integer> getBridgePlaceholders() {
        return this.bridgePlaceholders;
    }

    @Override
    public PermissionPlugin detectPermissionPlugin() {
        if (TAB.getInstance().getConfiguration().isBukkitPermissions()) {
            return new VaultBridge();
        }
        if (this.getPluginVersion("LuckPerms") != null) {
            return new LuckPerms(this.getPluginVersion("LuckPerms"));
        }
        return new VaultBridge();
    }

    @Override
    public void registerUnknownPlaceholder(String identifier) {
        int refresh;
        Placeholder placeholder;
        PlaceholderManagerImpl pl = TAB.getInstance().getPlaceholderManager();
        if (identifier.startsWith("%online_")) {
            String server = identifier.substring(8, identifier.length() - 1);
            pl.registerServerPlaceholder(identifier, 1000, () -> Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(p -> p.getServer().equals(server) && !p.isVanished()).count() + this.getRedisPlayers().values().stream().filter(all -> all.getServer().equals(server) && !all.isVanished()).count());
            return;
        }
        if (identifier.startsWith("%rel_")) {
            placeholder = pl.registerRelationalPlaceholder(identifier, -1, (viewer, target) -> null);
            refresh = pl.getRelationalRefresh(identifier);
        } else {
            placeholder = pl.registerPlayerPlaceholder(identifier, -1, player -> null);
            refresh = pl.getPlayerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getServerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getDefaultRefresh()));
        }
        this.bridgePlaceholders.put(placeholder.getIdentifier(), refresh);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.plm.sendMessage(all, "Placeholder", placeholder.getIdentifier(), refresh);
        }
    }

    private Map<String, RedisPlayer> getRedisPlayers() {
        RedisSupport support = (RedisSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
        return support == null ? Collections.emptyMap() : support.getRedisPlayers();
    }

    @Override
    public void loadFeatures() {
        TAB tab = TAB.getInstance();
        new UniversalPlaceholderRegistry().registerPlaceholders(tab.getPlaceholderManager());
        if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.enabled", true)) {
            if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.enabled", false)) {
                tab.getFeatureManager().registerFeature("NameTagX", new ProxyNameTagX());
            } else {
                tab.getFeatureManager().registerFeature("NameTag16", new NameTag());
            }
        }
        tab.loadUniversalFeatures();
        if (tab.getConfiguration().getConfig().getBoolean("bossbar.enabled", false)) {
            tab.getFeatureManager().registerFeature("BossBar", new BossBarManagerImpl());
        }
        if (tab.getConfiguration().getConfig().getBoolean("global-playerlist.enabled", false)) {
            tab.getFeatureManager().registerFeature("GlobalPlayerList", new GlobalPlayerList());
        }
        if (tab.getConfiguration().getConfig().getBoolean("fix-pet-names.enabled", false)) {
            tab.getFeatureManager().registerFeature("PetFix", new TabFeature("", ""){});
        }
        if (tab.getConfiguration().getConfig().getBoolean("placeholders.register-tab-expansion", false)) {
            tab.getPlaceholderManager().setTabExpansion(new ProxyTabExpansion());
        }
    }

    @Override
    public String getConfigName() {
        return "proxyconfig.yml";
    }
}

