/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.packets;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.rewriters.ItemRewriter;
import com.viaversion.viabackwards.api.rewriters.MapColorRewriter;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.Protocol1_16_4To1_17;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.data.MapColorRewrites;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.storage.PingRequests;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.storage.PlayerLastCursorItem;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.BlockChangeRecord;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_16_2;
import com.viaversion.viaversion.api.type.types.chunk.ChunkType1_17;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.LongArrayTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.ClientboundPackets1_16_2;
import com.viaversion.viaversion.protocols.protocol1_16_2to1_16_1.ServerboundPackets1_16_2;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ClientboundPackets1_17;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ServerboundPackets1_17;
import com.viaversion.viaversion.rewriter.BlockRewriter;
import com.viaversion.viaversion.rewriter.RecipeRewriter;
import com.viaversion.viaversion.util.CompactArrayUtil;
import com.viaversion.viaversion.util.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public final class BlockItemPackets1_17
extends ItemRewriter<ClientboundPackets1_17, ServerboundPackets1_16_2, Protocol1_16_4To1_17> {
    public BlockItemPackets1_17(Protocol1_16_4To1_17 protocol) {
        super(protocol);
    }

    protected void registerPackets() {
        BlockRewriter blockRewriter = BlockRewriter.for1_14((Protocol)this.protocol);
        new RecipeRewriter(this.protocol).register((ClientboundPacketType)ClientboundPackets1_17.DECLARE_RECIPES);
        this.registerSetCooldown((ClientboundPacketType)ClientboundPackets1_17.COOLDOWN);
        this.registerWindowItems((ClientboundPacketType)ClientboundPackets1_17.WINDOW_ITEMS, Type.ITEM1_13_2_SHORT_ARRAY);
        this.registerEntityEquipmentArray((ClientboundPacketType)ClientboundPackets1_17.ENTITY_EQUIPMENT);
        this.registerTradeList((ClientboundPacketType)ClientboundPackets1_17.TRADE_LIST);
        this.registerAdvancements(ClientboundPackets1_17.ADVANCEMENTS, (Type<Item>)Type.ITEM1_13_2);
        blockRewriter.registerAcknowledgePlayerDigging((ClientboundPacketType)ClientboundPackets1_17.ACKNOWLEDGE_PLAYER_DIGGING);
        blockRewriter.registerBlockAction((ClientboundPacketType)ClientboundPackets1_17.BLOCK_ACTION);
        blockRewriter.registerEffect((ClientboundPacketType)ClientboundPackets1_17.EFFECT, 1010, 2001);
        this.registerCreativeInvAction((ServerboundPacketType)ServerboundPackets1_16_2.CREATIVE_INVENTORY_ACTION, Type.ITEM1_13_2);
        ((Protocol1_16_4To1_17)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_16_2.EDIT_BOOK, wrapper -> this.handleItemToServer((Item)wrapper.passthrough(Type.ITEM1_13_2)));
        ((Protocol1_16_4To1_17)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_16_2.CLICK_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    short slot = (Short)wrapper.passthrough((Type)Type.SHORT);
                    byte button = (Byte)wrapper.passthrough((Type)Type.BYTE);
                    wrapper.read((Type)Type.SHORT);
                    int mode = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                    Item clicked = BlockItemPackets1_17.this.handleItemToServer((Item)wrapper.read(Type.ITEM1_13_2));
                    wrapper.write((Type)Type.VAR_INT, (Object)0);
                    PlayerLastCursorItem state = (PlayerLastCursorItem)wrapper.user().get(PlayerLastCursorItem.class);
                    if (mode == 0 && button == 0 && clicked != null) {
                        state.setLastCursorItem(clicked);
                    } else if (mode == 0 && button == 1 && clicked != null) {
                        if (state.isSet()) {
                            state.setLastCursorItem(clicked);
                        } else {
                            state.setLastCursorItem(clicked, (clicked.amount() + 1) / 2);
                        }
                    } else if (mode != 5 || slot != -999 || button != 0 && button != 4) {
                        state.setLastCursorItem(null);
                    }
                    Item carried = state.getLastCursorItem();
                    if (carried == null) {
                        wrapper.write(Type.ITEM1_13_2, (Object)clicked);
                    } else {
                        wrapper.write(Type.ITEM1_13_2, (Object)carried);
                    }
                });
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.SET_SLOT, wrapper -> {
            short windowId = (Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            short slot = (Short)wrapper.passthrough((Type)Type.SHORT);
            Item carried = (Item)wrapper.read(Type.ITEM1_13_2);
            if (carried != null && windowId == -1 && slot == -1) {
                ((PlayerLastCursorItem)wrapper.user().get(PlayerLastCursorItem.class)).setLastCursorItem(carried);
            }
            wrapper.write(Type.ITEM1_13_2, (Object)this.handleItemToClient(carried));
        });
        ((Protocol1_16_4To1_17)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_16_2.WINDOW_CONFIRMATION, null, wrapper -> {
            wrapper.cancel();
            if (!ViaBackwards.getConfig().handlePingsAsInvAcknowledgements()) {
                return;
            }
            short inventoryId = (Short)wrapper.read((Type)Type.UNSIGNED_BYTE);
            short confirmationId = (Short)wrapper.read((Type)Type.SHORT);
            boolean accepted = (Boolean)wrapper.read((Type)Type.BOOLEAN);
            if (inventoryId == 0 && accepted && ((PingRequests)wrapper.user().get(PingRequests.class)).removeId(confirmationId)) {
                PacketWrapper pongPacket = wrapper.create((PacketType)ServerboundPackets1_17.PONG);
                pongPacket.write((Type)Type.INT, (Object)confirmationId);
                pongPacket.sendToServer(Protocol1_16_4To1_17.class);
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.SPAWN_PARTICLE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map((Type)Type.BOOLEAN);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.FLOAT);
                this.map((Type)Type.INT);
                this.handler(wrapper -> {
                    int id = (Integer)wrapper.get((Type)Type.INT, 0);
                    if (id == 16) {
                        wrapper.passthrough((Type)Type.FLOAT);
                        wrapper.passthrough((Type)Type.FLOAT);
                        wrapper.passthrough((Type)Type.FLOAT);
                        wrapper.passthrough((Type)Type.FLOAT);
                        wrapper.read((Type)Type.FLOAT);
                        wrapper.read((Type)Type.FLOAT);
                        wrapper.read((Type)Type.FLOAT);
                    } else if (id == 37) {
                        wrapper.set((Type)Type.INT, 0, (Object)-1);
                        wrapper.cancel();
                    }
                });
                this.handler(BlockItemPackets1_17.this.getSpawnParticleHandler());
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).mergePacket(ClientboundPackets1_17.WORLD_BORDER_SIZE, ClientboundPackets1_16_2.WORLD_BORDER, 0);
        ((Protocol1_16_4To1_17)this.protocol).mergePacket(ClientboundPackets1_17.WORLD_BORDER_LERP_SIZE, ClientboundPackets1_16_2.WORLD_BORDER, 1);
        ((Protocol1_16_4To1_17)this.protocol).mergePacket(ClientboundPackets1_17.WORLD_BORDER_CENTER, ClientboundPackets1_16_2.WORLD_BORDER, 2);
        ((Protocol1_16_4To1_17)this.protocol).mergePacket(ClientboundPackets1_17.WORLD_BORDER_INIT, ClientboundPackets1_16_2.WORLD_BORDER, 3);
        ((Protocol1_16_4To1_17)this.protocol).mergePacket(ClientboundPackets1_17.WORLD_BORDER_WARNING_DELAY, ClientboundPackets1_16_2.WORLD_BORDER, 4);
        ((Protocol1_16_4To1_17)this.protocol).mergePacket(ClientboundPackets1_17.WORLD_BORDER_WARNING_DISTANCE, ClientboundPackets1_16_2.WORLD_BORDER, 5);
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.UPDATE_LIGHT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BOOLEAN);
                this.handler(wrapper -> {
                    EntityTracker tracker = wrapper.user().getEntityTracker(Protocol1_16_4To1_17.class);
                    int startFromSection = Math.max(0, -(tracker.currentMinY() >> 4));
                    long[] skyLightMask = (long[])wrapper.read(Type.LONG_ARRAY_PRIMITIVE);
                    long[] blockLightMask = (long[])wrapper.read(Type.LONG_ARRAY_PRIMITIVE);
                    int cutSkyLightMask = BlockItemPackets1_17.this.cutLightMask(skyLightMask, startFromSection);
                    int cutBlockLightMask = BlockItemPackets1_17.this.cutLightMask(blockLightMask, startFromSection);
                    wrapper.write((Type)Type.VAR_INT, (Object)cutSkyLightMask);
                    wrapper.write((Type)Type.VAR_INT, (Object)cutBlockLightMask);
                    long[] emptySkyLightMask = (long[])wrapper.read(Type.LONG_ARRAY_PRIMITIVE);
                    long[] emptyBlockLightMask = (long[])wrapper.read(Type.LONG_ARRAY_PRIMITIVE);
                    wrapper.write((Type)Type.VAR_INT, (Object)BlockItemPackets1_17.this.cutLightMask(emptySkyLightMask, startFromSection));
                    wrapper.write((Type)Type.VAR_INT, (Object)BlockItemPackets1_17.this.cutLightMask(emptyBlockLightMask, startFromSection));
                    this.writeLightArrays(wrapper, BitSet.valueOf(skyLightMask), cutSkyLightMask, startFromSection, tracker.currentWorldSectionHeight());
                    this.writeLightArrays(wrapper, BitSet.valueOf(blockLightMask), cutBlockLightMask, startFromSection, tracker.currentWorldSectionHeight());
                });
            }

            private void writeLightArrays(PacketWrapper wrapper, BitSet bitMask, int cutBitMask, int startFromSection, int sectionHeight) throws Exception {
                int i;
                wrapper.read((Type)Type.VAR_INT);
                ArrayList<byte[]> light = new ArrayList<byte[]>();
                for (i = 0; i < startFromSection; ++i) {
                    if (!bitMask.get(i)) continue;
                    wrapper.read(Type.BYTE_ARRAY_PRIMITIVE);
                }
                for (i = 0; i < 18; ++i) {
                    if (!this.isSet(cutBitMask, i)) continue;
                    light.add((byte[])wrapper.read(Type.BYTE_ARRAY_PRIMITIVE));
                }
                for (i = startFromSection + 18; i < sectionHeight + 2; ++i) {
                    if (!bitMask.get(i)) continue;
                    wrapper.read(Type.BYTE_ARRAY_PRIMITIVE);
                }
                for (byte[] bytes : light) {
                    wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)bytes);
                }
            }

            private boolean isSet(int mask, int i) {
                return (mask & 1 << i) != 0;
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.MULTI_BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.LONG);
                this.map((Type)Type.BOOLEAN);
                this.handler(wrapper -> {
                    BlockChangeRecord[] records;
                    long chunkPos = (Long)wrapper.get((Type)Type.LONG, 0);
                    int chunkY = (int)(chunkPos << 44 >> 44);
                    if (chunkY < 0 || chunkY > 15) {
                        wrapper.cancel();
                        return;
                    }
                    for (BlockChangeRecord record : records = (BlockChangeRecord[])wrapper.passthrough(Type.VAR_LONG_BLOCK_CHANGE_RECORD_ARRAY)) {
                        record.setBlockId(((Protocol1_16_4To1_17)BlockItemPackets1_17.this.protocol).getMappingData().getNewBlockStateId(record.getBlockId()));
                    }
                });
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.BLOCK_CHANGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.POSITION1_14);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int y = ((Position)wrapper.get(Type.POSITION1_14, 0)).y();
                    if (y < 0 || y > 255) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.set((Type)Type.VAR_INT, 0, (Object)((Protocol1_16_4To1_17)BlockItemPackets1_17.this.protocol).getMappingData().getNewBlockStateId((Integer)wrapper.get((Type)Type.VAR_INT, 0)));
                });
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.CHUNK_DATA, wrapper -> {
            EntityTracker tracker = wrapper.user().getEntityTracker(Protocol1_16_4To1_17.class);
            int currentWorldSectionHeight = tracker.currentWorldSectionHeight();
            Chunk chunk = (Chunk)wrapper.read((Type)new ChunkType1_17(currentWorldSectionHeight));
            wrapper.write(ChunkType1_16_2.TYPE, (Object)chunk);
            int startFromSection = Math.max(0, -(tracker.currentMinY() >> 4));
            chunk.setBiomeData(Arrays.copyOfRange(chunk.getBiomeData(), startFromSection * 64, startFromSection * 64 + 1024));
            chunk.setBitmask(this.cutMask(chunk.getChunkMask(), startFromSection, false));
            chunk.setChunkMask(null);
            ChunkSection[] sections = Arrays.copyOfRange(chunk.getSections(), startFromSection, startFromSection + 16);
            chunk.setSections(sections);
            CompoundTag heightMaps = chunk.getHeightMap();
            for (Tag heightMapTag : heightMaps.values()) {
                LongArrayTag heightMap = (LongArrayTag)heightMapTag;
                int[] heightMapData = new int[256];
                int bitsPerEntry = MathUtil.ceilLog2((int)((currentWorldSectionHeight << 4) + 1));
                CompactArrayUtil.iterateCompactArrayWithPadding((int)bitsPerEntry, (int)heightMapData.length, (long[])heightMap.getValue(), (i, v) -> {
                    heightMapData[i] = MathUtil.clamp((int)(v + tracker.currentMinY()), (int)0, (int)255);
                });
                heightMap.setValue(CompactArrayUtil.createCompactArrayWithPadding((int)9, (int)heightMapData.length, i -> heightMapData[i]));
            }
            for (int i2 = 0; i2 < 16; ++i2) {
                ChunkSection section = sections[i2];
                if (section == null) continue;
                DataPalette palette = section.palette(PaletteType.BLOCKS);
                for (int j = 0; j < palette.size(); ++j) {
                    int mappedBlockStateId = ((Protocol1_16_4To1_17)this.protocol).getMappingData().getNewBlockStateId(palette.idByIndex(j));
                    palette.setIdByIndex(j, mappedBlockStateId);
                }
            }
            chunk.getBlockEntities().removeIf(compound -> {
                NumberTag tag = (NumberTag)compound.get("y");
                return tag != null && (tag.asInt() < 0 || tag.asInt() > 255);
            });
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.BLOCK_ENTITY_DATA, wrapper -> {
            int y = ((Position)wrapper.passthrough(Type.POSITION1_14)).y();
            if (y < 0 || y > 255) {
                wrapper.cancel();
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.BLOCK_BREAK_ANIMATION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int y = ((Position)wrapper.passthrough(Type.POSITION1_14)).y();
                    if (y < 0 || y > 255) {
                        wrapper.cancel();
                    }
                });
            }
        });
        ((Protocol1_16_4To1_17)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_17.MAP_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BYTE);
                this.handler(wrapper -> wrapper.write((Type)Type.BOOLEAN, (Object)true));
                this.map((Type)Type.BOOLEAN);
                this.handler(wrapper -> {
                    boolean hasMarkers = (Boolean)wrapper.read((Type)Type.BOOLEAN);
                    if (!hasMarkers) {
                        wrapper.write((Type)Type.VAR_INT, (Object)0);
                    } else {
                        MapColorRewriter.getRewriteHandler(MapColorRewrites::getMappedColor).handle(wrapper);
                    }
                });
            }
        });
    }

    private int cutLightMask(long[] mask, int startFromSection) {
        if (mask.length == 0) {
            return 0;
        }
        return this.cutMask(BitSet.valueOf(mask), startFromSection, true);
    }

    private int cutMask(BitSet mask, int startFromSection, boolean lightMask) {
        int cutMask = 0;
        int to = startFromSection + (lightMask ? 18 : 16);
        int i = startFromSection;
        int j = 0;
        while (i < to) {
            if (mask.get(i)) {
                cutMask |= 1 << j;
            }
            ++i;
            ++j;
        }
        return cutMask;
    }
}

