/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3;

import com.google.common.base.Preconditions;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.rewriters.SoundRewriter;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.data.BackwardsMappings;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.packets.BlockItemPackets1_19_3;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.packets.EntityPackets1_19_3;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.storage.ChatSessionStorage;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.storage.ChatTypeStorage1_19_3;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.storage.NonceStorage;
import com.viaversion.viabackwards.protocol.protocol1_19to1_19_1.Protocol1_19To1_19_1;
import com.viaversion.viabackwards.protocol.protocol1_19to1_19_1.storage.ChatRegistryStorage;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.PlayerMessageSignature;
import com.viaversion.viaversion.api.minecraft.ProfileKey;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_19_3;
import com.viaversion.viaversion.api.minecraft.signature.SignableCommandArgumentsProvider;
import com.viaversion.viaversion.api.minecraft.signature.model.MessageMetadata;
import com.viaversion.viaversion.api.minecraft.signature.storage.ChatSession1_19_3;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.BitSetType;
import com.viaversion.viaversion.api.type.types.ByteArrayType;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.kyori.adventure.text.Component;
import com.viaversion.viaversion.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.ClientboundPackets1_19_1;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.ServerboundPackets1_19_1;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.ClientboundPackets1_19_3;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.ServerboundPackets1_19_3;
import com.viaversion.viaversion.rewriter.CommandRewriter;
import com.viaversion.viaversion.rewriter.ComponentRewriter;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;
import com.viaversion.viaversion.util.CipherUtil;
import com.viaversion.viaversion.util.Pair;
import java.util.BitSet;
import java.util.List;

public final class Protocol1_19_1To1_19_3
extends BackwardsProtocol<ClientboundPackets1_19_3, ClientboundPackets1_19_1, ServerboundPackets1_19_3, ServerboundPackets1_19_1> {
    public static final BackwardsMappings MAPPINGS = new BackwardsMappings();
    public static final ByteArrayType.OptionalByteArrayType OPTIONAL_SIGNATURE_BYTES_TYPE = new ByteArrayType.OptionalByteArrayType(256);
    public static final ByteArrayType SIGNATURE_BYTES_TYPE = new ByteArrayType(256);
    private final EntityPackets1_19_3 entityRewriter = new EntityPackets1_19_3(this);
    private final BlockItemPackets1_19_3 itemRewriter = new BlockItemPackets1_19_3(this);
    private final TranslatableRewriter<ClientboundPackets1_19_3> translatableRewriter = new TranslatableRewriter<ClientboundPackets1_19_3>(this, ComponentRewriter.ReadType.JSON);

    public Protocol1_19_1To1_19_3() {
        super(ClientboundPackets1_19_3.class, ClientboundPackets1_19_1.class, ServerboundPackets1_19_3.class, ServerboundPackets1_19_1.class);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19_3.SYSTEM_CHAT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19_3.ACTIONBAR);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19_3.TITLE_TEXT);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19_3.TITLE_SUBTITLE);
        this.translatableRewriter.registerBossBar((ClientboundPacketType)ClientboundPackets1_19_3.BOSSBAR);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_19_3.DISCONNECT);
        this.translatableRewriter.registerTabList((ClientboundPacketType)ClientboundPackets1_19_3.TAB_LIST);
        this.translatableRewriter.registerOpenWindow((ClientboundPacketType)ClientboundPackets1_19_3.OPEN_WINDOW);
        this.translatableRewriter.registerCombatKill((ClientboundPacketType)ClientboundPackets1_19_3.COMBAT_KILL);
        this.translatableRewriter.registerPing();
        SoundRewriter<ClientboundPackets1_19_3> soundRewriter = new SoundRewriter<ClientboundPackets1_19_3>(this);
        soundRewriter.registerStopSound(ClientboundPackets1_19_3.STOP_SOUND);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.SOUND, wrapper -> {
            int soundId = (Integer)wrapper.read((Type)Type.VAR_INT) - 1;
            if (soundId != -1) {
                int mappedId = MAPPINGS.getSoundMappings().getNewId(soundId);
                if (mappedId == -1) {
                    wrapper.cancel();
                    return;
                }
                wrapper.write((Type)Type.VAR_INT, (Object)mappedId);
                return;
            }
            String soundIdentifier = (String)wrapper.read(Type.STRING);
            wrapper.read((Type)Type.OPTIONAL_FLOAT);
            String mappedIdentifier = MAPPINGS.getMappedNamedSound(soundIdentifier);
            if (mappedIdentifier != null) {
                if (mappedIdentifier.isEmpty()) {
                    wrapper.cancel();
                    return;
                }
                soundIdentifier = mappedIdentifier;
            }
            wrapper.write(Type.STRING, (Object)soundIdentifier);
            wrapper.setPacketType((PacketType)ClientboundPackets1_19_1.NAMED_SOUND);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.ENTITY_SOUND, wrapper -> {
            int mappedId;
            int soundId = (Integer)wrapper.read((Type)Type.VAR_INT) - 1;
            if (soundId != -1) {
                int mappedId2 = MAPPINGS.getSoundMappings().getNewId(soundId);
                if (mappedId2 == -1) {
                    wrapper.cancel();
                    return;
                }
                wrapper.write((Type)Type.VAR_INT, (Object)mappedId2);
                return;
            }
            String soundIdentifier = (String)wrapper.read(Type.STRING);
            wrapper.read((Type)Type.OPTIONAL_FLOAT);
            String mappedIdentifier = MAPPINGS.getMappedNamedSound(soundIdentifier);
            if (mappedIdentifier != null) {
                if (mappedIdentifier.isEmpty()) {
                    wrapper.cancel();
                    return;
                }
                soundIdentifier = mappedIdentifier;
            }
            if ((mappedId = MAPPINGS.mappedSound(soundIdentifier)) == -1) {
                wrapper.cancel();
                return;
            }
            wrapper.write((Type)Type.VAR_INT, (Object)mappedId);
        });
        TagRewriter tagRewriter = new TagRewriter((Protocol)this);
        tagRewriter.addEmptyTag(RegistryType.BLOCK, "minecraft:non_flammable_wood");
        tagRewriter.addEmptyTag(RegistryType.ITEM, "minecraft:overworld_natural_logs");
        tagRewriter.registerGeneric((ClientboundPacketType)ClientboundPackets1_19_3.TAGS);
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_19_3.STATISTICS);
        CommandRewriter commandRewriter = new CommandRewriter((Protocol)this);
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.DECLARE_COMMANDS, wrapper -> {
            int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            for (int i = 0; i < size; ++i) {
                int nodeType;
                byte flags = (Byte)wrapper.passthrough((Type)Type.BYTE);
                wrapper.passthrough(Type.VAR_INT_ARRAY_PRIMITIVE);
                if ((flags & 8) != 0) {
                    wrapper.passthrough((Type)Type.VAR_INT);
                }
                if ((nodeType = flags & 3) == 1 || nodeType == 2) {
                    wrapper.passthrough(Type.STRING);
                }
                if (nodeType != 2) continue;
                int argumentTypeId = (Integer)wrapper.read((Type)Type.VAR_INT);
                int mappedArgumentTypeId = MAPPINGS.getArgumentTypeMappings().mappings().getNewId(argumentTypeId);
                Preconditions.checkArgument((mappedArgumentTypeId != -1 ? 1 : 0) != 0, (Object)("Unknown command argument type id: " + argumentTypeId));
                wrapper.write((Type)Type.VAR_INT, (Object)mappedArgumentTypeId);
                String identifier = MAPPINGS.getArgumentTypeMappings().identifier(argumentTypeId);
                commandRewriter.handleArgument(wrapper, identifier);
                if (identifier.equals("minecraft:gamemode")) {
                    wrapper.write((Type)Type.VAR_INT, (Object)0);
                }
                if ((flags & 0x10) == 0) continue;
                wrapper.passthrough(Type.STRING);
            }
            wrapper.passthrough((Type)Type.VAR_INT);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.SERVER_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.OPTIONAL_COMPONENT);
                this.map(Type.OPTIONAL_STRING);
                this.create((Type)Type.BOOLEAN, false);
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.HELLO.getId(), ServerboundLoginPackets.HELLO.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    ProfileKey profileKey = (ProfileKey)wrapper.read(Type.OPTIONAL_PROFILE_KEY);
                    if (profileKey == null) {
                        wrapper.user().put((StorableObject)new NonceStorage(null));
                    }
                });
            }
        });
        this.registerClientbound(State.LOGIN, ClientboundLoginPackets.HELLO.getId(), ClientboundLoginPackets.HELLO.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    if (wrapper.user().has(NonceStorage.class)) {
                        return;
                    }
                    byte[] publicKey = (byte[])wrapper.passthrough(Type.BYTE_ARRAY_PRIMITIVE);
                    byte[] nonce = (byte[])wrapper.passthrough(Type.BYTE_ARRAY_PRIMITIVE);
                    wrapper.user().put((StorableObject)new NonceStorage(CipherUtil.encryptNonce((byte[])publicKey, (byte[])nonce)));
                });
            }
        });
        this.registerServerbound(State.LOGIN, ServerboundLoginPackets.ENCRYPTION_KEY.getId(), ServerboundLoginPackets.ENCRYPTION_KEY.getId(), (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.BYTE_ARRAY_PRIMITIVE);
                this.handler(wrapper -> {
                    NonceStorage nonceStorage = (NonceStorage)wrapper.user().remove(NonceStorage.class);
                    boolean isNonce = (Boolean)wrapper.read((Type)Type.BOOLEAN);
                    if (!isNonce) {
                        wrapper.read((Type)Type.LONG);
                        wrapper.read(Type.BYTE_ARRAY_PRIMITIVE);
                        wrapper.write(Type.BYTE_ARRAY_PRIMITIVE, (Object)(nonceStorage.nonce() != null ? nonceStorage.nonce() : new byte[]{}));
                    }
                });
            }
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_19_1.CHAT_MESSAGE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.map((Type)Type.LONG);
                this.map((Type)Type.LONG);
                this.read(Type.BYTE_ARRAY_PRIMITIVE);
                this.read((Type)Type.BOOLEAN);
                this.read(Type.PLAYER_MESSAGE_SIGNATURE_ARRAY);
                this.read(Type.OPTIONAL_PLAYER_MESSAGE_SIGNATURE);
                this.handler(wrapper -> {
                    ChatSession1_19_3 chatSession = (ChatSession1_19_3)wrapper.user().get(ChatSession1_19_3.class);
                    if (chatSession != null) {
                        String message = (String)wrapper.get(Type.STRING, 0);
                        long timestamp = (Long)wrapper.get((Type)Type.LONG, 0);
                        long salt = (Long)wrapper.get((Type)Type.LONG, 1);
                        MessageMetadata metadata = new MessageMetadata(null, timestamp, salt);
                        byte[] signature = chatSession.signChatMessage(metadata, message, new PlayerMessageSignature[0]);
                        wrapper.write((Type)OPTIONAL_SIGNATURE_BYTES_TYPE, (Object)signature);
                    } else {
                        wrapper.write((Type)OPTIONAL_SIGNATURE_BYTES_TYPE, null);
                    }
                    wrapper.write((Type)Type.VAR_INT, (Object)0);
                    wrapper.write((Type)new BitSetType(20), (Object)new BitSet(20));
                });
            }
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_19_1.CHAT_COMMAND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.map((Type)Type.LONG);
                this.map((Type)Type.LONG);
                this.handler(wrapper -> {
                    ChatSession1_19_3 chatSession = (ChatSession1_19_3)wrapper.user().get(ChatSession1_19_3.class);
                    SignableCommandArgumentsProvider argumentsProvider = (SignableCommandArgumentsProvider)Via.getManager().getProviders().get(SignableCommandArgumentsProvider.class);
                    String command = (String)wrapper.get(Type.STRING, 0);
                    long timestamp = (Long)wrapper.get((Type)Type.LONG, 0);
                    long salt = (Long)wrapper.get((Type)Type.LONG, 1);
                    int signatures = (Integer)wrapper.read((Type)Type.VAR_INT);
                    for (int i = 0; i < signatures; ++i) {
                        wrapper.read(Type.STRING);
                        wrapper.read(Type.BYTE_ARRAY_PRIMITIVE);
                    }
                    wrapper.read((Type)Type.BOOLEAN);
                    if (chatSession != null && argumentsProvider != null) {
                        MessageMetadata metadata = new MessageMetadata(null, timestamp, salt);
                        List arguments = argumentsProvider.getSignableArguments(command);
                        wrapper.write((Type)Type.VAR_INT, (Object)arguments.size());
                        for (Pair argument : arguments) {
                            byte[] signature = chatSession.signChatMessage(metadata, (String)argument.value(), new PlayerMessageSignature[0]);
                            wrapper.write(Type.STRING, (Object)((String)argument.key()));
                            wrapper.write((Type)SIGNATURE_BYTES_TYPE, (Object)signature);
                        }
                    } else {
                        wrapper.write((Type)Type.VAR_INT, (Object)0);
                    }
                    boolean offset = false;
                    BitSet acknowledged = new BitSet(20);
                    wrapper.write((Type)Type.VAR_INT, (Object)0);
                    wrapper.write((Type)new BitSetType(20), (Object)acknowledged);
                });
                this.read(Type.PLAYER_MESSAGE_SIGNATURE_ARRAY);
                this.read(Type.OPTIONAL_PLAYER_MESSAGE_SIGNATURE);
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.PLAYER_CHAT, (ClientboundPacketType)ClientboundPackets1_19_1.SYSTEM_CHAT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.read(Type.UUID);
                this.read((Type)Type.VAR_INT);
                this.read((Type)OPTIONAL_SIGNATURE_BYTES_TYPE);
                this.handler(wrapper -> {
                    String plainContent = (String)wrapper.read(Type.STRING);
                    wrapper.read((Type)Type.LONG);
                    wrapper.read((Type)Type.LONG);
                    int lastSeen = (Integer)wrapper.read((Type)Type.VAR_INT);
                    for (int i = 0; i < lastSeen; ++i) {
                        int index = (Integer)wrapper.read((Type)Type.VAR_INT);
                        if (index != 0) continue;
                        wrapper.read((Type)SIGNATURE_BYTES_TYPE);
                    }
                    JsonElement unsignedContent = (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT);
                    JsonElement content = unsignedContent != null ? unsignedContent : GsonComponentSerializer.gson().serializeToTree((Component)Component.text((String)plainContent));
                    Protocol1_19_1To1_19_3.this.translatableRewriter.processText(content);
                    int filterMaskType = (Integer)wrapper.read((Type)Type.VAR_INT);
                    if (filterMaskType == 2) {
                        wrapper.read(Type.LONG_ARRAY_PRIMITIVE);
                    }
                    int chatTypeId = (Integer)wrapper.read((Type)Type.VAR_INT);
                    JsonElement senderName = (JsonElement)wrapper.read(Type.COMPONENT);
                    JsonElement targetName = (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT);
                    JsonElement result = Protocol1_19To1_19_1.decorateChatMessage((ChatRegistryStorage)wrapper.user().get(ChatTypeStorage1_19_3.class), chatTypeId, senderName, targetName, content);
                    if (result == null) {
                        wrapper.cancel();
                        return;
                    }
                    wrapper.write(Type.COMPONENT, (Object)result);
                    wrapper.write((Type)Type.BOOLEAN, (Object)false);
                });
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.DISGUISED_CHAT, (ClientboundPacketType)ClientboundPackets1_19_1.SYSTEM_CHAT, wrapper -> {
            JsonElement content = (JsonElement)wrapper.read(Type.COMPONENT);
            this.translatableRewriter.processText(content);
            int chatTypeId = (Integer)wrapper.read((Type)Type.VAR_INT);
            JsonElement senderName = (JsonElement)wrapper.read(Type.COMPONENT);
            JsonElement targetName = (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT);
            JsonElement result = Protocol1_19To1_19_1.decorateChatMessage((ChatRegistryStorage)wrapper.user().get(ChatTypeStorage1_19_3.class), chatTypeId, senderName, targetName, content);
            if (result == null) {
                wrapper.cancel();
                return;
            }
            wrapper.write(Type.COMPONENT, (Object)result);
            wrapper.write((Type)Type.BOOLEAN, (Object)false);
        });
        this.cancelClientbound((ClientboundPacketType)ClientboundPackets1_19_3.UPDATE_ENABLED_FEATURES);
        this.cancelServerbound((ServerboundPacketType)ServerboundPackets1_19_1.CHAT_PREVIEW);
        this.cancelServerbound((ServerboundPacketType)ServerboundPackets1_19_1.CHAT_ACK);
    }

    public void init(UserConnection user) {
        user.put((StorableObject)new ChatSessionStorage());
        user.put((StorableObject)new ChatTypeStorage1_19_3());
        this.addEntityTracker(user, (EntityTracker)new EntityTrackerBase(user, (EntityType)EntityTypes1_19_3.PLAYER));
    }

    @Override
    public BackwardsMappings getMappingData() {
        return MAPPINGS;
    }

    @Override
    public TranslatableRewriter<ClientboundPackets1_19_3> getTranslatableRewriter() {
        return this.translatableRewriter;
    }

    public BlockItemPackets1_19_3 getItemRewriter() {
        return this.itemRewriter;
    }

    public EntityPackets1_19_3 getEntityRewriter() {
        return this.entityRewriter;
    }
}

