/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.packets;

import com.viaversion.viabackwards.api.rewriters.EntityRewriter;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.Protocol1_19_1To1_19_3;
import com.viaversion.viabackwards.protocol.protocol1_19_1to1_19_3.storage.ChatTypeStorage1_19_3;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.ProfileKey;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_19_3;
import com.viaversion.viaversion.api.minecraft.signature.storage.ChatSession1_19_3;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.BitSetType;
import com.viaversion.viaversion.api.type.types.version.Types1_19;
import com.viaversion.viaversion.api.type.types.version.Types1_19_3;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.NumberTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_19_1to1_19.ClientboundPackets1_19_1;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.ClientboundPackets1_19_3;
import com.viaversion.viaversion.protocols.protocol1_19_3to1_19_1.ServerboundPackets1_19_3;
import java.util.BitSet;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EntityPackets1_19_3
extends EntityRewriter<ClientboundPackets1_19_3, Protocol1_19_1To1_19_3> {
    private static final BitSetType PROFILE_ACTIONS_ENUM_TYPE = new BitSetType(6);
    private static final int[] PROFILE_ACTIONS = new int[]{2, 4, 5};
    private static final int ADD_PLAYER = 0;
    private static final int INITIALIZE_CHAT = 1;
    private static final int UPDATE_GAMEMODE = 2;
    private static final int UPDATE_LISTED = 3;
    private static final int UPDATE_LATENCY = 4;
    private static final int UPDATE_DISPLAYNAME = 5;

    public EntityPackets1_19_3(Protocol1_19_1To1_19_3 protocol) {
        super(protocol, Types1_19.META_TYPES.optionalComponentType, Types1_19.META_TYPES.booleanType);
    }

    protected void registerPackets() {
        this.registerMetadataRewriter((ClientboundPacketType)ClientboundPackets1_19_3.ENTITY_METADATA, Types1_19_3.METADATA_LIST, Types1_19.METADATA_LIST);
        this.registerRemoveEntities((ClientboundPacketType)ClientboundPackets1_19_3.REMOVE_ENTITIES);
        this.registerTrackerWithData1_19(ClientboundPackets1_19_3.SPAWN_ENTITY, (EntityType)EntityTypes1_19_3.FALLING_BLOCK);
        ((Protocol1_19_1To1_19_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.JOIN_GAME, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map((Type)Type.BOOLEAN);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map(Type.STRING_ARRAY);
                this.map(Type.NAMED_COMPOUND_TAG);
                this.map(Type.STRING);
                this.map(Type.STRING);
                this.handler(EntityPackets1_19_3.this.dimensionDataHandler());
                this.handler(EntityPackets1_19_3.this.biomeSizeTracker());
                this.handler(EntityPackets1_19_3.this.worldDataTrackerHandlerByKey());
                this.handler(wrapper -> {
                    ChatTypeStorage1_19_3 chatTypeStorage = (ChatTypeStorage1_19_3)wrapper.user().get(ChatTypeStorage1_19_3.class);
                    chatTypeStorage.clear();
                    CompoundTag registry = (CompoundTag)wrapper.get(Type.NAMED_COMPOUND_TAG, 0);
                    ListTag chatTypes = (ListTag)((CompoundTag)registry.get("minecraft:chat_type")).get("value");
                    for (Tag chatType : chatTypes) {
                        CompoundTag chatTypeCompound = (CompoundTag)chatType;
                        NumberTag idTag = (NumberTag)chatTypeCompound.get("id");
                        chatTypeStorage.addChatType(idTag.asInt(), chatTypeCompound);
                    }
                });
                this.handler(wrapper -> {
                    ChatSession1_19_3 chatSession = (ChatSession1_19_3)wrapper.user().get(ChatSession1_19_3.class);
                    if (chatSession != null) {
                        PacketWrapper chatSessionUpdate = wrapper.create((PacketType)ServerboundPackets1_19_3.CHAT_SESSION_UPDATE);
                        chatSessionUpdate.write(Type.UUID, (Object)chatSession.getSessionId());
                        chatSessionUpdate.write(Type.PROFILE_KEY, (Object)chatSession.getProfileKey());
                        chatSessionUpdate.sendToServer(Protocol1_19_1To1_19_3.class);
                    }
                });
            }
        });
        ((Protocol1_19_1To1_19_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.RESPAWN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.STRING);
                this.map(Type.STRING);
                this.map((Type)Type.LONG);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BOOLEAN);
                this.map((Type)Type.BOOLEAN);
                this.handler(EntityPackets1_19_3.this.worldDataTrackerHandlerByKey());
                this.handler(wrapper -> {
                    byte keepDataMask = (Byte)wrapper.read((Type)Type.BYTE);
                    wrapper.write((Type)Type.BOOLEAN, (Object)((keepDataMask & 1) != 0 ? 1 : 0));
                });
            }
        });
        ((Protocol1_19_1To1_19_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.PLAYER_INFO_UPDATE, (ClientboundPacketType)ClientboundPackets1_19_1.PLAYER_INFO, wrapper -> {
            wrapper.cancel();
            BitSet actions = (BitSet)wrapper.read((Type)PROFILE_ACTIONS_ENUM_TYPE);
            int entries = (Integer)wrapper.read((Type)Type.VAR_INT);
            if (actions.get(0)) {
                PacketWrapper playerInfoPacket = wrapper.create((PacketType)ClientboundPackets1_19_1.PLAYER_INFO);
                playerInfoPacket.write((Type)Type.VAR_INT, (Object)0);
                playerInfoPacket.write((Type)Type.VAR_INT, (Object)entries);
                for (int i = 0; i < entries; ++i) {
                    int gamemode;
                    ProfileKey profileKey;
                    playerInfoPacket.write(Type.UUID, (Object)((UUID)wrapper.read(Type.UUID)));
                    playerInfoPacket.write(Type.STRING, (Object)((String)wrapper.read(Type.STRING)));
                    int properties = (Integer)wrapper.read((Type)Type.VAR_INT);
                    playerInfoPacket.write((Type)Type.VAR_INT, (Object)properties);
                    for (int j = 0; j < properties; ++j) {
                        playerInfoPacket.write(Type.STRING, (Object)((String)wrapper.read(Type.STRING)));
                        playerInfoPacket.write(Type.STRING, (Object)((String)wrapper.read(Type.STRING)));
                        playerInfoPacket.write(Type.OPTIONAL_STRING, (Object)((String)wrapper.read(Type.OPTIONAL_STRING)));
                    }
                    if (actions.get(1) && ((Boolean)wrapper.read((Type)Type.BOOLEAN)).booleanValue()) {
                        wrapper.read(Type.UUID);
                        profileKey = (ProfileKey)wrapper.read(Type.PROFILE_KEY);
                    } else {
                        profileKey = null;
                    }
                    int n = gamemode = actions.get(2) ? (Integer)wrapper.read((Type)Type.VAR_INT) : 0;
                    if (actions.get(3)) {
                        wrapper.read((Type)Type.BOOLEAN);
                    }
                    int latency = actions.get(4) ? (Integer)wrapper.read((Type)Type.VAR_INT) : 0;
                    JsonElement displayName = actions.get(5) ? (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT) : null;
                    playerInfoPacket.write((Type)Type.VAR_INT, (Object)gamemode);
                    playerInfoPacket.write((Type)Type.VAR_INT, (Object)latency);
                    playerInfoPacket.write(Type.OPTIONAL_COMPONENT, (Object)displayName);
                    playerInfoPacket.write(Type.OPTIONAL_PROFILE_KEY, (Object)profileKey);
                }
                playerInfoPacket.send(Protocol1_19_1To1_19_3.class);
                return;
            }
            PlayerProfileUpdate[] updates = new PlayerProfileUpdate[entries];
            for (int i = 0; i < entries; ++i) {
                UUID uuid = (UUID)wrapper.read(Type.UUID);
                int gamemode = 0;
                int latency = 0;
                JsonElement displayName = null;
                block8: for (int action : PROFILE_ACTIONS) {
                    if (!actions.get(action)) continue;
                    switch (action) {
                        case 2: {
                            gamemode = (Integer)wrapper.read((Type)Type.VAR_INT);
                            continue block8;
                        }
                        case 4: {
                            latency = (Integer)wrapper.read((Type)Type.VAR_INT);
                            continue block8;
                        }
                        case 5: {
                            displayName = (JsonElement)wrapper.read(Type.OPTIONAL_COMPONENT);
                        }
                    }
                }
                updates[i] = new PlayerProfileUpdate(uuid, gamemode, latency, displayName);
            }
            if (actions.get(2)) {
                this.sendPlayerProfileUpdate(wrapper.user(), 1, updates);
            } else if (actions.get(4)) {
                this.sendPlayerProfileUpdate(wrapper.user(), 2, updates);
            } else if (actions.get(5)) {
                this.sendPlayerProfileUpdate(wrapper.user(), 3, updates);
            }
        });
        ((Protocol1_19_1To1_19_3)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_19_3.PLAYER_INFO_REMOVE, (ClientboundPacketType)ClientboundPackets1_19_1.PLAYER_INFO, wrapper -> {
            UUID[] uuids = (UUID[])wrapper.read(Type.UUID_ARRAY);
            wrapper.write((Type)Type.VAR_INT, (Object)4);
            wrapper.write((Type)Type.VAR_INT, (Object)uuids.length);
            for (UUID uuid : uuids) {
                wrapper.write(Type.UUID, (Object)uuid);
            }
        });
    }

    private void sendPlayerProfileUpdate(UserConnection connection, int action, PlayerProfileUpdate[] updates) throws Exception {
        PacketWrapper playerInfoPacket = PacketWrapper.create((PacketType)ClientboundPackets1_19_1.PLAYER_INFO, (UserConnection)connection);
        playerInfoPacket.write((Type)Type.VAR_INT, (Object)action);
        playerInfoPacket.write((Type)Type.VAR_INT, (Object)updates.length);
        for (PlayerProfileUpdate update : updates) {
            playerInfoPacket.write(Type.UUID, (Object)update.uuid());
            if (action == 1) {
                playerInfoPacket.write((Type)Type.VAR_INT, (Object)update.gamemode());
                continue;
            }
            if (action == 2) {
                playerInfoPacket.write((Type)Type.VAR_INT, (Object)update.latency());
                continue;
            }
            if (action == 3) {
                playerInfoPacket.write(Type.OPTIONAL_COMPONENT, (Object)update.displayName());
                continue;
            }
            throw new IllegalArgumentException("Invalid action: " + action);
        }
        playerInfoPacket.send(Protocol1_19_1To1_19_3.class);
    }

    public void registerRewrites() {
        this.filter().handler((event, meta) -> {
            int id = meta.metaType().typeId();
            if (id > 2) {
                meta.setMetaType(Types1_19.META_TYPES.byId(id - 1));
            } else if (id != 2) {
                meta.setMetaType(Types1_19.META_TYPES.byId(id));
            }
        });
        this.registerMetaTypeHandler(Types1_19.META_TYPES.itemType, Types1_19.META_TYPES.blockStateType, null, Types1_19.META_TYPES.particleType, Types1_19.META_TYPES.componentType, Types1_19.META_TYPES.optionalComponentType);
        this.filter().index(6).handler((event, meta) -> {
            int pose = (Integer)meta.value();
            if (pose == 10) {
                meta.setValue((Object)0);
            } else if (pose > 10) {
                meta.setValue((Object)(pose - 1));
            }
        });
        this.filter().filterFamily((EntityType)EntityTypes1_19_3.MINECART_ABSTRACT).index(11).handler((event, meta) -> {
            int data = (Integer)meta.getValue();
            meta.setValue((Object)((Protocol1_19_1To1_19_3)this.protocol).getMappingData().getNewBlockStateId(data));
        });
        this.filter().type((EntityType)EntityTypes1_19_3.CAMEL).cancel(19);
        this.filter().type((EntityType)EntityTypes1_19_3.CAMEL).cancel(20);
    }

    public void onMappingDataLoaded() {
        this.mapTypes();
        this.mapEntityTypeWithData((EntityType)EntityTypes1_19_3.CAMEL, (EntityType)EntityTypes1_19_3.DONKEY).jsonName();
    }

    public EntityType typeFromId(int typeId) {
        return EntityTypes1_19_3.getTypeFromId((int)typeId);
    }

    private static final class PlayerProfileUpdate {
        private final UUID uuid;
        private final int gamemode;
        private final int latency;
        private final JsonElement displayName;

        private PlayerProfileUpdate(UUID uuid, int gamemode, int latency, @Nullable JsonElement displayName) {
            this.uuid = uuid;
            this.gamemode = gamemode;
            this.latency = latency;
            this.displayName = displayName;
        }

        public UUID uuid() {
            return this.uuid;
        }

        public int gamemode() {
            return this.gamemode;
        }

        public int latency() {
            return this.latency;
        }

        public @Nullable JsonElement displayName() {
            return this.displayName;
        }
    }
}

