/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.compat;

import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.item.ItemTypes;
import fr.mrmicky.worldeditselectionvisualizer.WorldEditSelectionVisualizer;
import fr.mrmicky.worldeditselectionvisualizer.compat.ClipboardAdapter;
import fr.mrmicky.worldeditselectionvisualizer.compat.RegionAdapter;
import fr.mrmicky.worldeditselectionvisualizer.compat.SpigotActionBarAdapter;
import fr.mrmicky.worldeditselectionvisualizer.compat.v6.ClipboardAdapter6;
import fr.mrmicky.worldeditselectionvisualizer.compat.v6.RegionAdapter6;
import fr.mrmicky.worldeditselectionvisualizer.compat.v7.ClipboardAdapter7;
import fr.mrmicky.worldeditselectionvisualizer.compat.v7.RegionAdapter7;
import java.lang.reflect.Field;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityHelper {
    private final WorldEditSelectionVisualizer plugin;
    private final boolean supportOffHand = this.isOffhandSupported();
    private final boolean supportActionBar = this.isActionBarSupported();
    private final boolean worldEdit7 = this.isWorldEdit7();
    @Nullable
    private Field wandItemField;

    public CompatibilityHelper(WorldEditSelectionVisualizer plugin) {
        this.plugin = plugin;
        plugin.getLogger().info("Using WorldEdit " + this.getWorldEditVersion() + " api");
        try {
            this.wandItemField = LocalConfiguration.class.getField("wandItem");
        }
        catch (NoSuchFieldException e) {
            plugin.getLogger().warning("No field 'wandItem' in LocalConfiguration");
        }
        if (this.wandItemField != null && this.wandItemField.getType() != Integer.TYPE && this.wandItemField.getType() != String.class) {
            plugin.getLogger().warning("Unsupported WorldEdit configuration, try to update WorldEdit (and FAWE if you have it)");
            this.wandItemField = null;
        }
    }

    public RegionAdapter adaptRegion(Region region) {
        return this.worldEdit7 ? new RegionAdapter7(region) : new RegionAdapter6(region);
    }

    public ClipboardAdapter adaptClipboard(Clipboard clipboard) {
        return this.worldEdit7 ? new ClipboardAdapter7(clipboard) : new ClipboardAdapter6(clipboard);
    }

    public int getWorldEditVersion() {
        return this.worldEdit7 ? 7 : 6;
    }

    public boolean isHoldingSelectionItem(@NotNull Player player) {
        return this.isSelectionItem(this.getItemInMainHand(player)) || this.isSelectionItem(this.getItemInOffHand(player));
    }

    public void sendActionBar(@NotNull Player player, @NotNull String message) {
        if (!this.supportActionBar) {
            player.sendMessage(message);
            return;
        }
        SpigotActionBarAdapter.sendActionBar(player, message);
    }

    public boolean isSelectionItem(@Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        if (this.wandItemField == null) {
            return true;
        }
        try {
            LocalConfiguration config = WorldEdit.getInstance().getConfiguration();
            if (this.wandItemField.getType() == Integer.TYPE) {
                return item.getType().getId() == this.wandItemField.getInt(config);
            }
            if (this.wandItemField.getType() == String.class) {
                String wandItem = (String)this.wandItemField.get(config);
                return BukkitAdapter.adapt((ItemStack)item).getType().equals((Object)ItemTypes.get((String)wandItem));
            }
        }
        catch (ReflectiveOperationException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred on isHoldingSelectionItem", e);
        }
        return true;
    }

    @NotNull
    private ItemStack getItemInMainHand(Player player) {
        return player.getItemInHand();
    }

    @Nullable
    private ItemStack getItemInOffHand(Player player) {
        if (!this.supportOffHand) {
            return null;
        }
        return player.getInventory().getItemInOffHand();
    }

    private boolean isActionBarSupported() {
        try {
            Class.forName("net.md_5.bungee.api.chat.TextComponent");
            Player.class.getMethod("spigot", new Class[0]);
            SpigotActionBarAdapter.checkSupported();
            return true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return false;
        }
    }

    private boolean isOffhandSupported() {
        try {
            PlayerInventory.class.getMethod("getItemInOffHand", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private boolean isWorldEdit7() {
        try {
            Class.forName("com.sk89q.worldedit.math.Vector3");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

