/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.config;

import fr.mrmicky.worldeditselectionvisualizer.config.SelectionConfig;
import fr.mrmicky.worldeditselectionvisualizer.display.DisplayType;
import org.jetbrains.annotations.NotNull;

public class GlobalSelectionConfig {
    private final int fadeDelay;
    private final int maxSelectionSize;
    @NotNull
    private final SelectionConfig primary;
    @NotNull
    private final SelectionConfig secondary;
    @NotNull
    private final SelectionConfig origin;

    public GlobalSelectionConfig(int fadeDelay, int maxSelectionSize, @NotNull SelectionConfig primary, @NotNull SelectionConfig secondary, @NotNull SelectionConfig origin) {
        this.fadeDelay = fadeDelay;
        this.maxSelectionSize = maxSelectionSize;
        this.primary = primary;
        this.secondary = secondary;
        this.origin = origin;
    }

    public int getFadeDelay() {
        return this.fadeDelay;
    }

    public int getMaxSelectionSize() {
        return this.maxSelectionSize;
    }

    @NotNull
    public SelectionConfig primary() {
        return this.primary;
    }

    @NotNull
    public SelectionConfig secondary() {
        return this.secondary;
    }

    @NotNull
    public SelectionConfig origin() {
        return this.origin;
    }

    @NotNull
    public SelectionConfig byType(DisplayType type) {
        switch (type) {
            case PRIMARY: {
                return this.primary;
            }
            case SECONDARY: {
                return this.secondary;
            }
            case ORIGIN: {
                return this.origin;
            }
        }
        throw new IllegalArgumentException("Invalid display type: " + (Object)((Object)type));
    }
}

