/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.libs.fastparticles;

import fr.mrmicky.worldeditselectionvisualizer.libs.fastparticles.ParticleTypes;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public interface ParticleType {
    public static ParticleType of(String name) {
        return ParticleTypes.of(name);
    }

    public String getName();

    public Class<?> getRawDataType();

    default public Class<?> getDataType() {
        Class<?> type = this.getRawDataType();
        return ParticleTypes.DATA_ADAPTERS.getOrDefault(type, type);
    }

    default public void spawn(World world, Location location, int count) {
        this.spawn(world, location.getX(), location.getY(), location.getZ(), count);
    }

    default public void spawn(World world, double x, double y, double z, int count) {
        this.spawn(world, x, y, z, count, null);
    }

    default public <T> void spawn(World world, Location location, int count, T data) {
        this.spawn(world, location.getX(), location.getY(), location.getZ(), count, data);
    }

    default public <T> void spawn(World world, double x, double y, double z, int count, T data) {
        this.spawn(world, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    default public void spawn(World world, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawn(world, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    default public void spawn(World world, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawn(world, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    default public <T> void spawn(World world, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawn(world, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    default public <T> void spawn(World world, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawn(world, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    default public void spawn(World world, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawn(world, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    default public void spawn(World world, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawn(world, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    default public <T> void spawn(World world, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawn(world, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawn(World var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15, T var17);

    default public void spawn(Player player, Location location, int count) {
        this.spawn(player, location.getX(), location.getY(), location.getZ(), count);
    }

    default public void spawn(Player player, double x, double y, double z, int count) {
        this.spawn(player, x, y, z, count, null);
    }

    default public <T> void spawn(Player player, Location location, int count, T data) {
        this.spawn(player, location.getX(), location.getY(), location.getZ(), count, data);
    }

    default public <T> void spawn(Player player, double x, double y, double z, int count, T data) {
        this.spawn(player, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    default public void spawn(Player player, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawn(player, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    default public void spawn(Player player, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawn(player, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    default public <T> void spawn(Player player, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawn(player, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    default public <T> void spawn(Player player, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawn(player, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    default public void spawn(Player player, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawn(player, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    default public void spawn(Player player, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawn(player, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    default public <T> void spawn(Player player, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawn(player, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawn(Player var1, double var2, double var4, double var6, int var8, double var9, double var11, double var13, double var15, T var17);
}

