/*
 * Decompiled with CFR 0.152.
 */
package fr.mrmicky.worldeditselectionvisualizer.selection;

import fr.mrmicky.worldeditselectionvisualizer.math.Vector3d;
import fr.mrmicky.worldeditselectionvisualizer.selection.RegionInfo;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionPoints;
import fr.mrmicky.worldeditselectionvisualizer.selection.SelectionType;
import java.time.Instant;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSelection {
    @NotNull
    private final SelectionType selectionType;
    @Nullable
    private SelectionPoints selectionPoints;
    @NotNull
    private Vector3d origin = Vector3d.ZERO;
    @Nullable
    private Instant expireTime;
    @Nullable
    private RegionInfo lastSelectedRegion;
    private boolean lastSelectionTooLarge;

    public PlayerSelection(@NotNull SelectionType selectionType) {
        this.selectionType = Objects.requireNonNull(selectionType, "selectionType");
    }

    @Nullable
    public SelectionPoints getSelectionPoints() {
        return this.selectionPoints;
    }

    @NotNull
    public Vector3d getOrigin() {
        return this.origin;
    }

    @Nullable
    public Instant getExpireTime() {
        return this.expireTime;
    }

    @Nullable
    public RegionInfo getLastSelectedRegion() {
        return this.lastSelectedRegion;
    }

    public boolean isLastSelectionTooLarge() {
        return this.lastSelectionTooLarge;
    }

    public void setLastSelectionTooLarge(boolean lastSelectionTooLarge) {
        this.lastSelectionTooLarge = lastSelectionTooLarge;
    }

    @NotNull
    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public long getSelectedVolume() {
        return this.lastSelectedRegion != null ? this.lastSelectedRegion.getVolume() : 0L;
    }

    @Contract(value="-> this")
    public PlayerSelection verifyExpireTime() {
        if (this.expireTime != null && this.expireTime.isBefore(Instant.now())) {
            this.expireTime = null;
            this.selectionPoints = null;
        }
        return this;
    }

    public void updateSelection(@Nullable SelectionPoints selectionPoints, @Nullable RegionInfo lastSelectedRegion, @NotNull Vector3d origin, int expireSeconds) {
        this.selectionPoints = selectionPoints;
        this.lastSelectedRegion = lastSelectedRegion;
        this.origin = origin;
        this.lastSelectionTooLarge = false;
        this.expireTime = expireSeconds > 0 ? Instant.now().plusSeconds(expireSeconds) : null;
    }

    public void resetSelection() {
        this.resetSelection(null);
    }

    public void resetSelection(RegionInfo lastSelectedRegion) {
        this.lastSelectedRegion = lastSelectedRegion;
        this.selectionPoints = null;
        this.origin = Vector3d.ZERO;
        this.expireTime = null;
        this.lastSelectionTooLarge = false;
    }
}

