/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Time.CMITimeManager;
import org.bukkit.BanEntry;

public class CMIBanEntry {
    long createdOn = 0L;
    long banUntil = 0L;
    String reason = null;
    CMIUser bannedBy = null;
    CMIUser banned = null;

    public CMIBanEntry(CMIUser cMIUser) {
        this.banned = cMIUser;
        this.createdOn = System.currentTimeMillis();
    }

    public Long getCreated() {
        return this.createdOn;
    }

    public Long getExpiration() {
        return this.banUntil;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSource() {
        if (this.bannedBy == null) {
            return LC.info_Console.getLocale(new Object[0]);
        }
        return this.bannedBy.getName();
    }

    public CMIUser getSourceUser() {
        return this.bannedBy;
    }

    public String getTarget() {
        return this.banned.getName();
    }

    public CMIUser getTargetUser() {
        return this.banned;
    }

    public void setCreated(Long l) {
        this.createdOn = l == null ? 0L : l;
    }

    public void setExpiration(Long l) {
        this.banUntil = l != null ? l : -1L;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public void setSource(CMIUser cMIUser) {
        this.bannedBy = cMIUser;
    }

    public boolean isPermanent() {
        if (this.banUntil >= 0L) {
            return false;
        }
        return this.banUntil == -1L;
    }

    public Long getLeftTime() {
        if (this.banUntil <= 0L) {
            return 0L;
        }
        if (this.banUntil < System.currentTimeMillis()) {
            return 0L;
        }
        return this.banUntil - System.currentTimeMillis();
    }

    public static String getBanMessage(BanEntry banEntry) {
        if (banEntry == null) {
            return "";
        }
        if (banEntry.getExpiration() == null) {
            String string = String.valueOf(CMILC.getIM("ban", "message", new Object[0])) + " \n";
            string = String.valueOf(string) + CMILC.getIM("ban", "reason", "[reason]", banEntry.getReason() != null ? banEntry.getReason() : CMILC.getIM("ban", "defaultReason", new Object[0]));
            return string;
        }
        String string = String.valueOf(CMILC.getIM("tempban", "message", new Object[0])) + " \n";
        string = String.valueOf(string) + CMILC.getIM("ban", "reason", "[reason]", banEntry.getReason() != null ? banEntry.getReason() : CMILC.getIM("ban", "defaultReason", new Object[0]));
        if (banEntry.getExpiration() != null) {
            string = String.valueOf(string) + " \n" + CMILC.getIM("tempban", "time", "[time]", CMITimeManager.to24hourShort((Long)(banEntry.getExpiration().getTime() - System.currentTimeMillis() + 1000L)));
        }
        return string;
    }

    public static String getIpBanMessage(BanEntry banEntry) {
        if (banEntry == null) {
            return "";
        }
        if (banEntry.getExpiration() == null) {
            String string = String.valueOf(CMILC.getIM("ipban", "message", new Object[0])) + " \n";
            string = String.valueOf(string) + CMILC.getIM("ban", "reason", "[reason]", banEntry.getReason() != null ? banEntry.getReason() : CMILC.getIM("ban", "defaultReason", new Object[0]));
            return string;
        }
        String string = String.valueOf(CMILC.getIM("tempipban", "message", new Object[0])) + " \n";
        string = String.valueOf(string) + CMILC.getIM("ban", "reason", "[reason]", banEntry.getReason() != null ? banEntry.getReason() : CMILC.getIM("ban", "defaultReason", new Object[0]));
        if (banEntry.getExpiration() != null) {
            string = String.valueOf(string) + " \n" + CMILC.getIM("tempban", "time", "[time]", CMITimeManager.to24hourShort((Long)(banEntry.getExpiration().getTime() - System.currentTimeMillis() + 1000L)));
        }
        return string;
    }
}

