/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFilter;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.ChatFilter.ChatFilterRule;
import com.Zrips.CMI.Modules.ChatFilter.RuleResponce;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.Map;
import net.Zrips.CMILib.Colors.CMIChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class ChatFilterListener
implements Listener {
    private CMI plugin;

    public ChatFilterListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void capsFilter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        boolean bl = this.plugin.getChatFilterManager().checkCaps(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void AsyncPlayerChatEvent(final AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        final RuleResponce ruleResponce = this.plugin.getChatFilterManager().getCorrectMessage(asyncPlayerChatEvent.getPlayer(), asyncPlayerChatEvent.getMessage());
        if (ruleResponce.getRules().isEmpty()) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!PermissionsManager.CMIPerm.chatfilter_inform.hasPermission((CommandSender)player)) continue;
            for (Map.Entry<String, ChatFilterRule> entry : ruleResponce.getRules().entrySet()) {
                ChatFilterRule chatFilterRule;
                if (ruleResponce.isBypass(entry.getValue().getGroup()) || (chatFilterRule = entry.getValue()).getMessageToStaff() == null || chatFilterRule.getMessageToStaff().isEmpty()) continue;
                player.sendMessage(CMIChatColor.translate((String)this.plugin.getLM().updateSnd(new Snd().setSender(player).setTarget(asyncPlayerChatEvent.getPlayer()), chatFilterRule.getMessageToStaff())).replace("[message]", asyncPlayerChatEvent.getMessage()));
            }
        }
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Snd snd = new Snd().setSender(asyncPlayerChatEvent.getPlayer()).setTarget(asyncPlayerChatEvent.getPlayer());
                for (Map.Entry<String, ChatFilterRule> entry : ruleResponce.getRules().entrySet()) {
                    for (String string : entry.getValue().getCommands()) {
                        if (ruleResponce.isBypass(entry.getValue().getGroup())) continue;
                        String string2 = ChatFilterListener.this.plugin.getLM().updateSnd(snd, string);
                        string2 = string2.replace("[message]", ruleResponce.getMessage());
                        string2 = string2.replace("[updatedmessage]", ruleResponce.getUpdatedMessage());
                        ChatFilterListener.this.plugin.getSpecializedCommandManager().executeCmd(string2, null);
                    }
                }
            }
        }, 1L);
        switch (ruleResponce.getMaxFilterBlockType()) {
            case All: {
                asyncPlayerChatEvent.setCancelled(true);
                asyncPlayerChatEvent.getRecipients().clear();
                return;
            }
            case None: {
                break;
            }
            case Others: {
                Player player;
                player = asyncPlayerChatEvent.getPlayer();
                asyncPlayerChatEvent.getRecipients().clear();
                asyncPlayerChatEvent.getRecipients().add(player);
                break;
            }
        }
        if (ruleResponce.isInformConsole()) {
            this.plugin.consoleMessage(CMILC.info_spamConsoleInform.getLocale("[playerName]", asyncPlayerChatEvent.getPlayer().getName(), "[rules]", ruleResponce.getRulesNamesAsString(), "[message]", ruleResponce.getMessage()));
        }
        asyncPlayerChatEvent.setMessage(ruleResponce.getUpdatedMessage());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void spamFilter(AsyncPlayerChatEvent asyncPlayerChatEvent) {
        if (asyncPlayerChatEvent.isCancelled()) {
            return;
        }
        Player player = asyncPlayerChatEvent.getPlayer();
        if (this.plugin.getChatFilterManager().isSpam(player, asyncPlayerChatEvent.getMessage())) {
            CMILC.info_noSpam.sendMessage(player, new Snd().setSender(player).setTarget(player));
            asyncPlayerChatEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void spamCommandFilter(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        if (this.plugin.getChatFilterManager().isSpamedCommand(player, playerCommandPreprocessEvent.getMessage())) {
            CMILC.info_noCmdSpam.sendMessage(player, new Snd().setSender(player).setTarget(player));
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onSignChangeEventAdvertisement(SignChangeEvent signChangeEvent) {
        if (signChangeEvent.isCancelled()) {
            return;
        }
        Player player = signChangeEvent.getPlayer();
        if (player == null) {
            return;
        }
        String[] stringArray = signChangeEvent.getLines();
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            if (!string.isEmpty()) {
                string = String.valueOf(string) + "%break%";
            }
            string = String.valueOf(string) + stringArray[n];
            ++n;
        }
        this.plugin.getPlayerManager().sendMessageToSignSpies(player, string, signChangeEvent.getBlock().getLocation());
    }
}

