/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shade.org.checkerframework.checker.nullness.qual.NonNull;
import org.maxgamer.quickshop.shop.Shop;

public class Cache {
    private final QuickShop plugin;
    private final com.google.common.cache.Cache<Location, Shop> accessCaching = CacheBuilder.newBuilder().initialCapacity(1000).expireAfterAccess(120L, TimeUnit.MINUTES).weakValues().recordStats().build();

    public Cache(QuickShop plugin) {
        this.plugin = plugin;
    }

    public @NonNull CacheStats getStats() {
        return this.accessCaching.stats();
    }

    @Nullable
    public Shop getCaching(@NotNull Location location, boolean includeAttached) {
        Shop shop = this.accessCaching.getIfPresent(location);
        if (shop == null) {
            shop = includeAttached ? this.plugin.getShopManager().getShopIncludeAttached(location, false) : this.plugin.getShopManager().getShop(location);
        }
        if (shop != null) {
            this.setCache(location, shop);
        }
        return shop;
    }

    public void setCache(@NotNull Location location, @Nullable Shop shop) {
        if (shop == null) {
            this.accessCaching.invalidate(location);
            return;
        }
        this.accessCaching.put(location, shop);
    }
}

