/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.util.Copied;
import org.maxgamer.quickshop.util.Util;

public class Language {
    private final QuickShop plugin;

    Language(QuickShop plugin) {
        this.plugin = plugin;
    }

    public void saveFile(@NotNull String language, @NotNull String type, @NotNull String fileName) {
        File targetFile = new File(this.plugin.getDataFolder(), fileName);
        if (!targetFile.exists()) {
            try {
                targetFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to save translation files.", e);
            }
        }
        try (InputStream is = this.getFile(language, type);){
            new Copied(targetFile).accept(is);
        }
        catch (Exception err) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save translation files.", err);
        }
    }

    @Nullable
    public InputStream getFile(@Nullable String language, @Nullable String type) {
        if (language == null) {
            language = "en-US";
            Util.debugLog("Using the default language (EN) cause language is null.");
        }
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Type cannot be null or empty");
        }
        InputStream inputStream = this.plugin.getResource("lang/" + language + "/" + type + ".json");
        if (inputStream == null) {
            Util.debugLog("Using the default language because we can't get the InputStream.");
            inputStream = this.plugin.getResource("lang/en-US/" + type + ".json");
        }
        return inputStream;
    }
}

