/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.shade.org.apache.commons.compress.utils.Lists;
import org.maxgamer.quickshop.shop.Shop;

public class ShopAPI {
    private final QuickShop plugin;

    public List<Shop> getAllShops() {
        return this.plugin.getShopManager().getAllShops();
    }

    public List<Shop> getLoadedShops() {
        return new ArrayList<Shop>(this.plugin.getShopManager().getLoadedShops());
    }

    public List<Shop> getShops(World world) {
        return this.plugin.getShopManager().getShopsInWorld(world);
    }

    public List<Shop> getShops(UUID player) {
        return this.plugin.getShopManager().getPlayerAllShops(player);
    }

    public List<Shop> getShops(World world, UUID player) {
        return this.plugin.getShopManager().getPlayerAllShops(player).stream().filter(shop -> Objects.requireNonNull(shop.getLocation().getWorld()).equals(world)).collect(Collectors.toList());
    }

    public List<Shop> getShops(Chunk chunk) {
        Map<Location, Shop> mapping = this.plugin.getShopManager().getShops(chunk);
        return mapping == null ? Lists.newArrayList() : new ArrayList<Shop>(mapping.values());
    }

    public Optional<Shop> getShop(Block block) {
        return Optional.ofNullable(this.plugin.getShopManager().getShopIncludeAttached(block.getLocation()));
    }

    public Optional<Shop> getShop(Location location) {
        return Optional.ofNullable(this.plugin.getShopManager().getShopIncludeAttached(location));
    }

    @Deprecated
    @Nullable
    public Shop getShopWithCaching(@NotNull Location location) {
        if (this.plugin.getShopCache() == null) {
            return this.getShop(location).orElse(null);
        }
        return this.plugin.getShopCache().getCaching(location, false);
    }

    @Deprecated
    @Nullable
    public Shop getShopIncludeAttached(@NotNull Location location) {
        return this.plugin.getShopManager().getShopIncludeAttached(location);
    }

    @Deprecated
    @Nullable
    public Shop getShopIncludeAttachedWithCaching(@NotNull Location location) {
        if (this.plugin.getShopCache() == null) {
            return this.getShopIncludeAttached(location);
        }
        return this.plugin.getShopCache().getCaching(location, true);
    }

    @Deprecated
    @NotNull
    public List<Shop> getPlayerAllShops(@NotNull UUID uuid) {
        return new ArrayList<Shop>(this.plugin.getShopManager().getPlayerAllShops(uuid));
    }

    @Deprecated
    @NotNull
    public List<Shop> getShopsInWorld(@NotNull World world) {
        return new ArrayList<Shop>(this.plugin.getShopManager().getShopsInWorld(world));
    }

    public ShopAPI(QuickShop plugin) {
        this.plugin = plugin;
    }
}

