/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.chat.platform.minedown;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.chat.QuickChat;
import org.maxgamer.quickshop.chat.QuickComponent;
import org.maxgamer.quickshop.chat.QuickComponentImpl;
import org.maxgamer.quickshop.shade.de.themoep.minedown.minedown.MineDown;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.ReflectFactory;
import org.maxgamer.quickshop.util.Util;

public class BungeeQuickChat
implements QuickChat {
    private final QuickShop plugin = QuickShop.getInstance();

    @Override
    public void send(@NotNull CommandSender receiver, @Nullable String message) {
        if (StringUtils.isEmpty((String)message)) {
            return;
        }
        receiver.spigot().sendMessage(new MineDown(message).toComponent());
    }

    @Override
    public void send(@NotNull CommandSender receiver, @Nullable QuickComponent component) {
        if (component == null) {
            return;
        }
        if (component.get() instanceof BaseComponent[]) {
            receiver.spigot().sendMessage((BaseComponent[])component.get());
            return;
        }
        if (component.get() instanceof BaseComponent) {
            receiver.spigot().sendMessage((BaseComponent)component.get());
            return;
        }
        Util.debugLog("Illegal component " + component.get().getClass().getName() + " sending to " + this.getClass().getName() + " processor, trying force sending.");
    }

    @Override
    public void sendItemHologramChat(@NotNull Player player, @NotNull String text, @NotNull ItemStack itemStack) {
        TextComponent errorComponent = new TextComponent(MsgUtil.getMessage("menu.item-holochat-error", (CommandSender)player, new String[0]));
        try {
            String json = ReflectFactory.convertBukkitItemStackToJson(itemStack);
            TextComponent centerItem = new TextComponent(text);
            ComponentBuilder cBuilder = new ComponentBuilder(json);
            centerItem.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, cBuilder.create()));
            player.spigot().sendMessage((BaseComponent)centerItem);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to process chat component", e);
            player.spigot().sendMessage((BaseComponent)errorComponent);
        }
    }

    @Override
    @NotNull
    public QuickComponent getItemHologramChat(@NotNull Shop shop, @NotNull ItemStack itemStack, @NotNull Player player, @NotNull String message) {
        TextComponent errorComponent = new TextComponent(MsgUtil.getMessage("menu.item-holochat-error", (CommandSender)player, new String[0]));
        try {
            String json = ReflectFactory.convertBukkitItemStackToJson(itemStack);
            if (json == null) {
                return new QuickComponentImpl(errorComponent);
            }
            TextComponent normalmessage = new TextComponent(message + " " + MsgUtil.getMessage("menu.preview", (CommandSender)player, new String[0]));
            ComponentBuilder cBuilder = new ComponentBuilder(json);
            if (QuickShop.getPermissionManager().hasPermission((CommandSender)player, "quickshop.preview")) {
                normalmessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, MsgUtil.fillArgs("/qs silentpreview {0}", shop.getRuntimeRandomUniqueId().toString())));
            }
            normalmessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, cBuilder.create()));
            return new QuickComponentImpl(normalmessage);
        }
        catch (Throwable t) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to process chat component", t);
            return new QuickComponentImpl(errorComponent);
        }
    }

    @Override
    @NotNull
    public QuickComponent getItemTextComponent(@NotNull Player player, @NotNull ItemStack itemStack, @NotNull String normalText) {
        String json;
        TextComponent errorComponent = new TextComponent(MsgUtil.getMessage("menu.item-holochat-error", (CommandSender)player, new String[0]));
        try {
            json = ReflectFactory.convertBukkitItemStackToJson(itemStack);
        }
        catch (Throwable throwable) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to saving item to json for holochat", throwable);
            return new QuickComponentImpl(errorComponent);
        }
        if (json == null) {
            return new QuickComponentImpl(errorComponent);
        }
        BaseComponent[] component = TextComponent.fromLegacyText((String)(normalText + " " + MsgUtil.getMessage("menu.preview", (CommandSender)player, new String[0])));
        return new QuickComponentImpl(component);
    }

    @Override
    public void sendExecutableChat(@NotNull CommandSender receiver, @NotNull String message, @NotNull String hoverText, @NotNull String command) {
        TextComponent component = new TextComponent(ChatColor.DARK_PURPLE + MsgUtil.getMessage("tableformat.left_begin", receiver, new String[0]) + message);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverText).create()));
        receiver.spigot().sendMessage((BaseComponent)component);
    }

    @Override
    public void sendSuggestedChat(@NotNull CommandSender receiver, @NotNull String message, @NotNull String hoverText, @NotNull String command) {
        TextComponent component = new TextComponent(ChatColor.DARK_PURPLE + MsgUtil.getMessage("tableformat.left_begin", receiver, new String[0]) + message);
        component.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverText).create()));
        receiver.spigot().sendMessage((BaseComponent)component);
    }
}

