/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandContainer;
import org.maxgamer.quickshop.command.subcommand.SubCommand_About;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Amount;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Buy;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Clean;
import org.maxgamer.quickshop.command.subcommand.SubCommand_CleanGhost;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Convert;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Create;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Currency;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Debug;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Empty;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Export;
import org.maxgamer.quickshop.command.subcommand.SubCommand_FetchMessage;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Find;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Help;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Info;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Item;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Paste;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Price;
import org.maxgamer.quickshop.command.subcommand.SubCommand_ROOT;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Recovery;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Refill;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Reload;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Remove;
import org.maxgamer.quickshop.command.subcommand.SubCommand_RemoveAll;
import org.maxgamer.quickshop.command.subcommand.SubCommand_RemoveWorld;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Reset;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Sell;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SetOwner;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SilentBuy;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SilentEmpty;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SilentPreview;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SilentRemove;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SilentSell;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SilentUnlimited;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Size;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Staff;
import org.maxgamer.quickshop.command.subcommand.SubCommand_SuperCreate;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Transfer;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Unlimited;
import org.maxgamer.quickshop.command.subcommand.SubCommand_Update;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class CommandManager
implements TabCompleter,
CommandExecutor {
    private static final String[] EMPTY_ARGS = new String[0];
    private final Set<CommandContainer> cmds = Sets.newCopyOnWriteArraySet();
    private final QuickShop plugin;
    private final CommandContainer rootContainer;

    public CommandManager(QuickShop plugin) {
        this.plugin = plugin;
        this.rootContainer = CommandContainer.builder().prefix("").permission(null).executor(new SubCommand_ROOT(plugin)).build();
        this.registerCmd(CommandContainer.builder().prefix("help").permission(null).executor(new SubCommand_Help(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("unlimited").permission("quickshop.unlimited").executor(new SubCommand_Unlimited(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("silentunlimited").hidden(true).permission("quickshop.unlimited").executor(new SubCommand_SilentUnlimited(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("slientunlimited").hidden(true).permission("quickshop.unlimited").executor(new SubCommand_SilentUnlimited(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("transfer").permission("quickshop.transfer").executor(new SubCommand_Transfer(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("setowner").permission("quickshop.setowner").executor(new SubCommand_SetOwner(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("owner").hidden(true).permission("quickshop.setowner").executor(new SubCommand_SetOwner(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("amount").permission(null).executor(new SubCommand_Amount(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("buy").permission("quickshop.create.buy").executor(new SubCommand_Buy(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("sell").permission("quickshop.create.sell").executor(new SubCommand_Sell(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("silentbuy").hidden(true).permission("quickshop.create.buy").executor(new SubCommand_SilentBuy(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("silentsell").hidden(true).permission("quickshop.create.sell").executor(new SubCommand_SilentSell(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("price").permission("quickshop.create.changeprice").executor(new SubCommand_Price(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("remove").permission(null).executor(new SubCommand_Remove(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("silentremove").hidden(true).permission(null).executor(new SubCommand_SilentRemove(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("empty").permission("quickshop.empty").executor(new SubCommand_Empty(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("refill").permission("quickshop.refill").executor(new SubCommand_Refill(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("silentempty").hidden(true).permission("quickshop.empty").executor(new SubCommand_SilentEmpty(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("silentpreview").hidden(true).permission("quickshop.preview").executor(new SubCommand_SilentPreview(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("clean").permission("quickshop.clean").executor(new SubCommand_Clean(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("reload").permission("quickshop.reload").executor(new SubCommand_Reload(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("about").permission("quickshop.about").executor(new SubCommand_About(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("debug").permission("quickshop.debug").executor(new SubCommand_Debug(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("fetchmessage").permission("quickshop.fetchmessage").executor(new SubCommand_FetchMessage()).build());
        this.registerCmd(CommandContainer.builder().prefix("info").permission("quickshop.info").executor(new SubCommand_Info(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("paste").permission("quickshop.paste").executor(new SubCommand_Paste(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("staff").permission("quickshop.staff").executor(new SubCommand_Staff(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("create").permission("quickshop.create.cmd").permission("quickshop.create.sell").executor(new SubCommand_Create(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("update").hidden(true).permission("quickshop.alerts").executor(new SubCommand_Update(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("find").permission("quickshop.find").executor(new SubCommand_Find(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("supercreate").permission("quickshop.create.admin").permission("quickshop.create.sell").executor(new SubCommand_SuperCreate(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("cleanghost").permission("quickshop.cleanghost").hidden(true).executor(new SubCommand_CleanGhost(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("reset").hidden(true).permission("quickshop.reset").executor(new SubCommand_Reset(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("recovery").hidden(true).permission("quickshop.recovery").executor(new SubCommand_Recovery(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("export").hidden(true).permission("quickshop.export").executor(new SubCommand_Export()).build());
        this.registerCmd(CommandContainer.builder().prefix("convert").hidden(true).permission("quickshop.convert").executor(new SubCommand_Convert(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("size").permission("quickshop.create.stacks").permission("quickshop.create.changeamount").executor(new SubCommand_Size(plugin)).disabled(!plugin.isAllowStack()).disablePlaceholder(MsgUtil.getMessage("command.feature-not-enabled", null, new String[0])).build());
        this.registerCmd(CommandContainer.builder().prefix("item").permission("quickshop.create.changeitem").executor(new SubCommand_Item(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("removeall").selectivePermission("quickshop.removeall.other").selectivePermission("quickshop.removeall.self").executor(new SubCommand_RemoveAll(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("removeworld").permission("quickshop.removeworld").executor(new SubCommand_RemoveWorld(plugin)).build());
        this.registerCmd(CommandContainer.builder().prefix("currency").permission("quickshop.currency").executor(new SubCommand_Currency(plugin)).build());
    }

    public void registerCmd(@NotNull CommandContainer container) {
        if (this.cmds.contains(container)) {
            Util.debugLog("Dupe subcommand registering: " + container);
            return;
        }
        container.bakeExecutorType();
        this.cmds.removeIf(commandContainer -> commandContainer.getPrefix().equalsIgnoreCase(container.getPrefix()));
        this.cmds.add(container);
    }

    public void unregisterCmd(@NotNull CommandContainer container) {
        this.cmds.remove(container);
    }

    @NotNull
    public List<CommandContainer> getRegisteredCommands() {
        return new ArrayList<CommandContainer>(this.getCmds());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (this.plugin.getBootError() != null) {
            if (cmdArg.length <= 0) {
                this.plugin.getBootError().printErrors(sender);
                return true;
            }
            if (!"paste".equalsIgnoreCase(cmdArg[0])) {
                this.plugin.getBootError().printErrors(sender);
                return true;
            }
        }
        if (sender instanceof Player && this.plugin.getConfig().getBoolean("effect.sound.oncommand")) {
            Player player = (Player)sender;
            ((Player)sender).playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 80.0f, 1.0f);
        }
        if (cmdArg.length == 0) {
            Util.debugLog("Print help cause no args (/qs)");
            this.rootContainer.getExecutor().onCommand((CommandSender)this.capture(sender), commandLabel, EMPTY_ARGS);
        } else {
            String[] passThroughArgs = new String[cmdArg.length - 1];
            System.arraycopy(cmdArg, 1, passThroughArgs, 0, passThroughArgs.length);
            for (CommandContainer container : this.cmds) {
                if (!container.getPrefix().equalsIgnoreCase(cmdArg[0])) continue;
                if (container.isDisabled()) {
                    MsgUtil.sendDirectMessage(sender, container.getDisableText(sender));
                    return true;
                }
                if (!this.isAdapt(container, sender)) {
                    MsgUtil.sendMessage(sender, "command-type-mismatch", container.getExecutorType().getSimpleName());
                    return true;
                }
                List<String> requirePermissions = container.getPermissions();
                List<String> selectivePermissions = container.getSelectivePermissions();
                if (!this.checkPermissions(sender, commandLabel, passThroughArgs, requirePermissions, PermissionType.REQUIRE, Action.EXECUTE)) {
                    MsgUtil.sendMessage(sender, "no-permission", new String[0]);
                    return true;
                }
                if (!this.checkPermissions(sender, commandLabel, passThroughArgs, selectivePermissions, PermissionType.SELECTIVE, Action.EXECUTE)) {
                    MsgUtil.sendMessage(sender, "no-permission", new String[0]);
                    return true;
                }
                Util.debugLog("Execute container: " + container.getPrefix() + " - " + cmdArg[0]);
                container.getExecutor().onCommand((CommandSender)this.capture(sender), commandLabel, passThroughArgs);
                return true;
            }
            Util.debugLog("All checks failed, print helps");
            this.rootContainer.getExecutor().onCommand((CommandSender)this.capture(sender), commandLabel, passThroughArgs);
        }
        return true;
    }

    private <T1, T2 extends T1> T2 capture(T1 type) {
        return (T2)type;
    }

    private boolean checkPermissions(CommandSender sender, String commandLabel, String[] cmdArg, List<String> permissionList, PermissionType permissionType, Action action) {
        if (permissionList == null || permissionList.isEmpty()) {
            return true;
        }
        if (permissionType == PermissionType.REQUIRE) {
            for (String requirePermission : permissionList) {
                if (requirePermission == null || requirePermission.isEmpty() || QuickShop.getPermissionManager().hasPermission(sender, requirePermission)) continue;
                Util.debugLog("Sender " + sender.getName() + " trying " + action.name + " the command: " + commandLabel + " " + Util.array2String(cmdArg) + ", but no permission " + requirePermission);
                return false;
            }
            return true;
        }
        for (String selectivePermission : permissionList) {
            if (selectivePermission == null || selectivePermission.isEmpty() || !QuickShop.getPermissionManager().hasPermission(sender, selectivePermission)) continue;
            return true;
        }
        Util.debugLog("Sender " + sender.getName() + " trying " + action.name + " the command: " + commandLabel + " " + Util.array2String(cmdArg) + ", but does no have one of those permissions: " + permissionList);
        return false;
    }

    private boolean isAdapt(CommandContainer container, CommandSender sender) {
        return container.getExecutorType().isInstance(sender);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (this.plugin.getBootError() != null) {
            return Collections.emptyList();
        }
        if (sender instanceof Player && this.plugin.getConfig().getBoolean("effect.sound.ontabcomplete")) {
            Player player = (Player)sender;
            ((Player)sender).playSound(player.getLocation(), Sound.BLOCK_DISPENSER_FAIL, 80.0f, 1.0f);
        }
        if (cmdArg.length <= 1) {
            return this.getRootContainer().getExecutor().onTabComplete((CommandSender)this.capture(sender), commandLabel, cmdArg);
        }
        String[] passThroughArgs = new String[cmdArg.length - 1];
        System.arraycopy(cmdArg, 1, passThroughArgs, 0, passThroughArgs.length);
        for (CommandContainer container : this.cmds) {
            if (!container.getPrefix().toLowerCase().startsWith(cmdArg[0])) continue;
            if (!this.isAdapt(container, sender)) {
                return Collections.emptyList();
            }
            List<String> requirePermissions = container.getPermissions();
            List<String> selectivePermissions = container.getSelectivePermissions();
            if (!this.checkPermissions(sender, commandLabel, passThroughArgs, requirePermissions, PermissionType.REQUIRE, Action.TAB_COMPLETE)) {
                return Collections.emptyList();
            }
            if (!this.checkPermissions(sender, commandLabel, passThroughArgs, selectivePermissions, PermissionType.SELECTIVE, Action.TAB_COMPLETE)) {
                return Collections.emptyList();
            }
            Util.debugLog("Tab-complete container: " + container.getPrefix());
            return container.getExecutor().onTabComplete((CommandSender)this.capture(sender), commandLabel, passThroughArgs);
        }
        return Collections.emptyList();
    }

    public Set<CommandContainer> getCmds() {
        return this.cmds;
    }

    public QuickShop getPlugin() {
        return this.plugin;
    }

    public CommandContainer getRootContainer() {
        return this.rootContainer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandManager)) {
            return false;
        }
        CommandManager other = (CommandManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<CommandContainer> this$cmds = this.getCmds();
        Set<CommandContainer> other$cmds = other.getCmds();
        if (this$cmds == null ? other$cmds != null : !((Object)this$cmds).equals(other$cmds)) {
            return false;
        }
        QuickShop this$plugin = this.getPlugin();
        QuickShop other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !((Object)((Object)this$plugin)).equals((Object)other$plugin)) {
            return false;
        }
        CommandContainer this$rootContainer = this.getRootContainer();
        CommandContainer other$rootContainer = other.getRootContainer();
        return !(this$rootContainer == null ? other$rootContainer != null : !((Object)this$rootContainer).equals(other$rootContainer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CommandManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<CommandContainer> $cmds = this.getCmds();
        result = result * 59 + ($cmds == null ? 43 : ((Object)$cmds).hashCode());
        QuickShop $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : ((Object)((Object)$plugin)).hashCode());
        CommandContainer $rootContainer = this.getRootContainer();
        result = result * 59 + ($rootContainer == null ? 43 : ((Object)$rootContainer).hashCode());
        return result;
    }

    public String toString() {
        return "CommandManager(cmds=" + this.getCmds() + ", plugin=" + (Object)((Object)this.getPlugin()) + ", rootContainer=" + this.getRootContainer() + ")";
    }

    private static enum PermissionType {
        REQUIRE,
        SELECTIVE;

    }

    private static enum Action {
        EXECUTE("execute"),
        TAB_COMPLETE("tab-complete");

        final String name;

        private Action(String name) {
            this.name = name;
        }
    }
}

