/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.database.DatabaseHelper;
import org.maxgamer.quickshop.database.DatabaseManager;
import org.maxgamer.quickshop.database.MySQLCore;
import org.maxgamer.quickshop.database.SQLiteCore;
import org.maxgamer.quickshop.shop.Shop;

public class SubCommand_Convert
implements CommandHandler<ConsoleCommandSender> {
    private final QuickShop plugin;
    private volatile boolean running;

    public SubCommand_Convert(QuickShop plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onCommand(@NotNull ConsoleCommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length == 0) {
            sender.sendMessage(ChatColor.RED + "Please select what you want convert to: mysql or sqlite");
            return;
        }
        if (this.running) {
            sender.sendMessage(ChatColor.RED + "Conversion is already running! Please wait until it has finished!");
            return;
        }
        if ("mysql".equalsIgnoreCase(cmdArg[0])) {
            if (this.plugin.getDatabaseManager().getDatabase() instanceof MySQLCore) {
                sender.sendMessage(ChatColor.RED + "Your database is already in MySQL!");
                return;
            }
            ConfigurationSection dbCfg = this.plugin.getConfig().getConfigurationSection("database");
            String user = dbCfg.getString("user");
            String pass = dbCfg.getString("password");
            String host = dbCfg.getString("host");
            String port = dbCfg.getString("port");
            String databaseStr = dbCfg.getString("database");
            boolean useSSL = dbCfg.getBoolean("usessl");
            this.running = true;
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    MySQLCore dbCore = new MySQLCore(this.plugin, Objects.requireNonNull(host, "MySQL host can't be null"), Objects.requireNonNull(user, "MySQL username can't be null"), Objects.requireNonNull(pass, "MySQL password can't be null"), Objects.requireNonNull(databaseStr, "MySQL database name can't be null"), Objects.requireNonNull(port, "MySQL port can't be null"), useSSL);
                    DatabaseManager databaseManager = new DatabaseManager(QuickShop.getInstance(), dbCore);
                    sender.sendMessage(ChatColor.GREEN + "Converting...");
                    this.transferShops(new DatabaseHelper(this.plugin, databaseManager), (CommandSender)sender);
                    databaseManager.unInit();
                    sender.sendMessage(ChatColor.GREEN + "All done, please change your config.yml settings to mysql to apply the changes.");
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + "Error in database conversion! Please check your console.");
                    this.plugin.getServer().getLogger().log(Level.SEVERE, "Error in database conversion", e);
                }
                finally {
                    this.running = false;
                }
            });
        } else if ("sqlite".equalsIgnoreCase(cmdArg[0])) {
            if (this.plugin.getDatabaseManager().getDatabase() instanceof SQLiteCore) {
                sender.sendMessage(ChatColor.GREEN + "Your database is already in SQLite!");
                return;
            }
            this.running = true;
            this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                try {
                    SQLiteCore core = new SQLiteCore(this.plugin, new File(this.plugin.getDataFolder(), "shops.db"));
                    DatabaseManager databaseManager = new DatabaseManager(QuickShop.getInstance(), core);
                    sender.sendMessage(ChatColor.GREEN + "Converting...");
                    this.transferShops(new DatabaseHelper(this.plugin, databaseManager), (CommandSender)sender);
                    databaseManager.unInit();
                    sender.sendMessage(ChatColor.GREEN + "All done, please change your config.yml settings to sqlite to apply the changes.");
                }
                catch (Exception e) {
                    sender.sendMessage(ChatColor.RED + "Error in database conversion! Please check your console.");
                    this.plugin.getServer().getLogger().log(Level.SEVERE, "Error in database conversion", e);
                }
                finally {
                    this.running = false;
                }
            });
        } else {
            sender.sendMessage(ChatColor.RED + "Invalid type! Please choose mysql or sqlite");
        }
    }

    private void transferShops(@NotNull DatabaseHelper helper, @NotNull CommandSender sender) {
        this.plugin.getShopManager().getAllShops().forEach(shop -> {
            helper.removeShop((Shop)shop);
            helper.createShop((Shop)shop, null, ignored -> sender.sendMessage("Failed to convert shop " + shop));
        });
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull ConsoleCommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length < 2) {
            ArrayList<String> str = new ArrayList<String>();
            str.add("sqlite");
            str.add("mysql");
            return str;
        }
        return Collections.emptyList();
    }
}

