/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Info;
import org.maxgamer.quickshop.shop.ShopAction;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.holder.Result;

public class SubCommand_Create
implements CommandHandler<Player> {
    private final QuickShop plugin;

    public SubCommand_Create(@NotNull QuickShop plugin) {
        this.plugin = plugin;
    }

    @Nullable
    private Material matchMaterial(String itemName) {
        Material material = Material.matchMaterial((String)itemName);
        if (this.isValidMaterial(material)) {
            return material;
        }
        ConfigurationSection section = MsgUtil.getItemi18n().getConfigurationSection("itemi18n");
        for (String itemKey : Objects.requireNonNull(section).getKeys(false)) {
            if (!itemName.equalsIgnoreCase(section.getString(itemKey))) continue;
            material = Material.matchMaterial((String)itemKey);
            break;
        }
        if (!this.isValidMaterial(material)) {
            return null;
        }
        return material;
    }

    private boolean isValidMaterial(@Nullable Material material) {
        return material != null && !Util.isAir(material);
    }

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        ItemStack item;
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        if (cmdArg.length < 1) {
            MsgUtil.sendMessage((CommandSender)sender, "command.wrong-args", new String[0]);
            return;
        }
        if (cmdArg.length == 1) {
            item = sender.getInventory().getItemInMainHand();
            if (Util.isAir(item.getType())) {
                MsgUtil.sendMessage((CommandSender)sender, "no-anythings-in-your-hand", new String[0]);
                return;
            }
        } else {
            Material material = this.matchMaterial(cmdArg[1]);
            if (material == null) {
                MsgUtil.sendMessage((CommandSender)sender, "item-not-exist", cmdArg[1]);
                return;
            }
            if (cmdArg.length > 2 && QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quicshop.create.stack") && this.plugin.isAllowStack()) {
                try {
                    int amount = Integer.parseInt(cmdArg[2]);
                    if (amount < 1) {
                        amount = 1;
                    }
                    item = new ItemStack(material, amount);
                }
                catch (NumberFormatException e) {
                    item = new ItemStack(material, 1);
                }
            } else {
                item = new ItemStack(material, 1);
            }
        }
        Util.debugLog("Pending task for material: " + item);
        String price = cmdArg[0];
        while (bIt.hasNext()) {
            BlockFace blockFace;
            Result result;
            Block b = bIt.next();
            if (!Util.canBeShop(b)) continue;
            if (sender.isOnline() && !(result = this.plugin.getPermissionChecker().canBuild(sender, b)).isSuccess()) {
                MsgUtil.sendMessage((CommandSender)sender, "3rd-plugin-build-check-failed", result.getMessage());
                Util.debugLog("Failed to create shop because the protection check has failed! Reason:" + result.getMessage());
                return;
            }
            try {
                blockFace = sender.getFacing();
            }
            catch (Exception throwable) {
                blockFace = Util.getYawFace(sender.getLocation().getYaw());
            }
            if (!this.plugin.getShopManager().canBuildShop(sender, b, blockFace)) {
                Util.debugLog("Util report you can't build shop there.");
                return;
            }
            if (Util.isDoubleChest(b.getBlockData()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.create.double")) {
                MsgUtil.sendMessage((CommandSender)sender, "no-double-chests", new String[0]);
                return;
            }
            if (Util.isBlacklisted(item) && !QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.bypass." + item.getType().name())) {
                MsgUtil.sendMessage((CommandSender)sender, "blacklisted-item", new String[0]);
                return;
            }
            this.plugin.getShopManager().getActions().put(sender.getUniqueId(), new Info(b.getLocation(), ShopAction.CREATE, item, b.getRelative(sender.getFacing().getOppositeFace())));
            this.plugin.getShopManager().handleChat(sender, price);
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length == 1) {
            return Collections.singletonList(MsgUtil.getMessage("tabcomplete.price", (CommandSender)sender, new String[0]));
        }
        if (cmdArg.length == 2) {
            return Collections.singletonList(MsgUtil.getMessage("tabcomplete.item", (CommandSender)sender, new String[0]));
        }
        if (cmdArg.length == 3) {
            return Collections.singletonList(MsgUtil.getMessage("tabcomplete.amount", (CommandSender)sender, new String[0]));
        }
        return Collections.emptyList();
    }
}

