/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shade.io.papermc.lib.PaperLib;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Find
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length == 0) {
            MsgUtil.sendMessage((CommandSender)sender, "command.no-type-given", new String[0]);
            return;
        }
        Location loc = sender.getLocation().clone();
        Vector playerVector = loc.toVector();
        StringBuilder sb = new StringBuilder(cmdArg[0]);
        for (int i = 1; i < cmdArg.length; ++i) {
            sb.append("_").append(cmdArg[i]);
        }
        String lookFor = sb.toString().toLowerCase();
        double maxDistance = this.plugin.getConfig().getInt("shop.finding.distance");
        boolean usingOldLogic = this.plugin.getConfig().getBoolean("shop.finding.oldLogic");
        int shopLimit = usingOldLogic ? 1 : this.plugin.getConfig().getInt("shop.finding.limit");
        boolean allShops = this.plugin.getConfig().getBoolean("shop.finding.all");
        boolean excludeOutOfStock = this.plugin.getConfig().getBoolean("shop.finding.exclude-out-of-stock");
        HashMap<Shop, Double> aroundShops = new HashMap<Shop, Double>();
        Collection<Shop> scanPool = allShops ? this.plugin.getShopManager().getAllShops() : this.plugin.getShopManager().getLoadedShops();
        for (Shop shop : scanPool) {
            if (!Objects.equals(shop.getLocation().getWorld(), loc.getWorld())) continue;
            if (aroundShops.size() == shopLimit) break;
            Vector shopVector = shop.getLocation().toVector();
            double distance = shopVector.distance(playerVector);
            if (!(distance <= maxDistance) || !Util.getItemStackName(shop.getItem()).toLowerCase().contains(lookFor) && !shop.getItem().getType().name().toLowerCase().contains(lookFor) || excludeOutOfStock && (shop.isSelling() ? shop.getRemainingStock() == 0 : shop.isBuying() && shop.getRemainingSpace() == 0)) continue;
            aroundShops.put(shop, distance);
        }
        if (aroundShops.isEmpty()) {
            MsgUtil.sendMessage((CommandSender)sender, "no-nearby-shop", lookFor);
            return;
        }
        List sortedShops = aroundShops.entrySet().stream().sorted(Map.Entry.comparingByValue(Double::compare).reversed()).collect(Collectors.toList());
        if (usingOldLogic) {
            Map.Entry closest = (Map.Entry)sortedShops.get(0);
            Location lookAt = ((Shop)closest.getKey()).getLocation().clone().add(0.5, 0.5, 0.5);
            PaperLib.teleportAsync((Entity)sender, Util.lookAt(sender.getEyeLocation(), lookAt).add(0.0, -1.62, 0.0), PlayerTeleportEvent.TeleportCause.UNKNOWN);
            MsgUtil.sendMessage((CommandSender)sender, "nearby-shop-this-way", String.valueOf(((Double)closest.getValue()).intValue()));
        } else {
            StringBuilder stringBuilder = new StringBuilder(MsgUtil.getMessage("nearby-shop-header", (CommandSender)sender, lookFor)).append("\n");
            for (Map.Entry shopDoubleEntry : sortedShops) {
                Shop shop = (Shop)shopDoubleEntry.getKey();
                Location location = shop.getLocation();
                stringBuilder.append(MsgUtil.getMessage("nearby-shop-entry", (CommandSender)sender, shop.getSignText()[1], shop.getSignText()[3], location.getBlockX(), location.getBlockY(), location.getBlockZ(), ((Double)shopDoubleEntry.getValue()).intValue())).append("\n");
            }
            MsgUtil.sendDirectMessage((CommandSender)sender, stringBuilder.toString());
        }
    }

    public SubCommand_Find(QuickShop plugin) {
        this.plugin = plugin;
    }
}

