/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.ContainerShop;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopChunk;
import org.maxgamer.quickshop.util.MsgUtil;

public class SubCommand_Info
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        int buying = 0;
        int selling = 0;
        int doubles = 0;
        int chunks = 0;
        int worlds = 0;
        int doubleschests = 0;
        int nostock = 0;
        for (Map<ShopChunk, Map<Location, Shop>> inWorld : this.plugin.getShopManager().getShops().values()) {
            ++worlds;
            for (Map<Location, Shop> inChunk : inWorld.values()) {
                ++chunks;
                for (Shop shop : inChunk.values()) {
                    if (shop.isBuying()) {
                        ++buying;
                    } else if (shop.isSelling()) {
                        ++selling;
                    }
                    if (shop instanceof ContainerShop && ((ContainerShop)shop).isDoubleShop()) {
                        ++doubles;
                    } else if (shop.isSelling() && shop.getRemainingStock() == 0) {
                        ++nostock;
                    }
                    if (!(shop instanceof ContainerShop) || !((ContainerShop)shop).isDoubleChestShop()) continue;
                    ++doubleschests;
                }
            }
        }
        MsgUtil.sendDirectMessage(sender, ChatColor.RED + "QuickShop Statistics...");
        MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "Server UniqueID: " + this.plugin.getServerUniqueID());
        MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "" + (buying + selling) + " shops in " + chunks + " chunks spread over " + worlds + " worlds.");
        MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "" + doubles + " double shops. (" + doubleschests + " shops created on double chest.)");
        MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "" + nostock + " out-of-stock shops (excluding doubles) which will be removed by /qs clean.");
        MsgUtil.sendDirectMessage(sender, ChatColor.GREEN + "QuickShop " + QuickShop.getVersion());
    }

    public SubCommand_Info(QuickShop plugin) {
        this.plugin = plugin;
    }
}

