/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.util.Util;
import org.maxgamer.quickshop.util.paste.Paste;

public class SubCommand_Paste
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (this.plugin.getServer().getPluginManager().getPlugin("ConsoleSpamFix") != null) {
                if (cmdArg.length < 1) {
                    sender.sendMessage("Warning: ConsoleSpamFix is installed! Please disable it before reporting any errors!");
                    return;
                }
                if (Arrays.stream(cmdArg).noneMatch(str -> str.contains("--force"))) {
                    sender.sendMessage("Warning: ConsoleSpamFix is installed! Please disable it before reporting any errors!");
                    return;
                }
            }
            if (Arrays.stream(cmdArg).anyMatch(str -> str.contains("file"))) {
                this.pasteToLocalFile(sender);
                return;
            }
            sender.sendMessage("\u00a7aPlease wait, QS is uploading the data to pastebin...");
            if (!this.pasteToPastebin(sender)) {
                sender.sendMessage("The paste upload has failed! Saving the paste locally...");
                this.pasteToLocalFile(sender);
            }
        });
    }

    private boolean pasteToPastebin(@NotNull CommandSender sender) {
        Paste paste = new Paste(this.plugin);
        String pasteText = paste.genNewPaste();
        String pasteResult = paste.paste(pasteText);
        if (pasteResult != null) {
            sender.sendMessage(pasteResult);
            this.plugin.log(pasteResult);
            return true;
        }
        return false;
    }

    private boolean pasteToLocalFile(@NotNull CommandSender sender) {
        File file = new File(this.plugin.getDataFolder(), "paste");
        file.mkdirs();
        file = new File(file, "paste-" + UUID.randomUUID().toString().replaceAll("-", "") + ".txt");
        Paste paste = new Paste(this.plugin);
        String pasteText = paste.genNewPaste();
        try {
            boolean createResult = file.createNewFile();
            Util.debugLog("Create paste file: " + file.getCanonicalPath() + " " + createResult);
            try (FileWriter fwriter = new FileWriter(file);){
                fwriter.write(pasteText);
                fwriter.flush();
            }
            sender.sendMessage("The paste was saved to " + file.getAbsolutePath());
            return true;
        }
        catch (IOException e) {
            this.plugin.getSentryErrorReporter().ignoreThrow();
            this.plugin.getLogger().log(Level.WARNING, "Failed to save paste locally! The content will be send to the console", e);
            sender.sendMessage("Paste save failed! Sending paste to the console...");
            this.plugin.getLogger().info(pasteText);
            return false;
        }
    }

    public SubCommand_Paste(QuickShop plugin) {
        this.plugin = plugin;
    }
}

