/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.economy.EconomyTransaction;
import org.maxgamer.quickshop.shop.ContainerShop;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.PriceLimiter;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Price
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        BlockIterator bIt;
        double price;
        if (cmdArg.length < 1) {
            MsgUtil.sendMessage((CommandSender)sender, "no-price-given", new String[0]);
            return;
        }
        try {
            price = Double.parseDouble(cmdArg[0]);
        }
        catch (NumberFormatException ex) {
            Util.debugLog(ex.getMessage());
            MsgUtil.sendMessage((CommandSender)sender, "not-a-number", cmdArg[0]);
            return;
        }
        if (Double.isInfinite(price) || Double.isNaN(price)) {
            MsgUtil.sendMessage((CommandSender)sender, "not-a-number", cmdArg[0]);
            return;
        }
        boolean format = this.plugin.getConfig().getBoolean("use-decimal-format");
        double fee = 0.0;
        if (this.plugin.isPriceChangeRequiresFee()) {
            fee = this.plugin.getConfig().getDouble("shop.fee-for-price-change");
        }
        if (!(bIt = new BlockIterator((LivingEntity)sender, 10)).hasNext()) {
            MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
            return;
        }
        PriceLimiter limiter = new PriceLimiter(this.plugin.getConfig().getDouble("shop.minimum-price"), this.plugin.getConfig().getInt("shop.maximum-price"), this.plugin.getConfig().getBoolean("shop.allow-free-shop"), this.plugin.getConfig().getBoolean("whole-number-prices-only"));
        while (bIt.hasNext()) {
            EconomyTransaction transaction;
            Block b = bIt.next();
            Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
            if (shop == null || !shop.getModerator().isModerator(sender.getUniqueId()) && !QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.other.price")) continue;
            if (shop.getPrice() == price) {
                MsgUtil.sendMessage((CommandSender)sender, "no-price-change", new String[0]);
                return;
            }
            PriceLimiter.CheckResult checkResult = limiter.check(shop.getItem(), price);
            if (checkResult.getStatus() == PriceLimiter.Status.REACHED_PRICE_MIN_LIMIT) {
                MsgUtil.sendMessage((CommandSender)sender, "price-too-cheap", format ? MsgUtil.decimalFormat(checkResult.getMin()) : Double.toString(checkResult.getMin()));
                return;
            }
            if (checkResult.getStatus() == PriceLimiter.Status.REACHED_PRICE_MAX_LIMIT) {
                MsgUtil.sendMessage((CommandSender)sender, "price-too-high", format ? MsgUtil.decimalFormat(checkResult.getMax()) : Double.toString(checkResult.getMax()));
                return;
            }
            if (checkResult.getStatus() == PriceLimiter.Status.PRICE_RESTRICTED) {
                MsgUtil.sendMessage((CommandSender)sender, "restricted-prices", Util.getItemStackName(shop.getItem()), String.valueOf(checkResult.getMin()), String.valueOf(checkResult.getMax()));
                return;
            }
            if (fee > 0.0 && !(transaction = EconomyTransaction.builder().allowLoan(this.plugin.getConfig().getBoolean("shop.allow-economy-loan", false)).core(this.plugin.getEconomy()).from(sender.getUniqueId()).amount(fee).world(Objects.requireNonNull(shop.getLocation().getWorld())).currency(shop.getCurrency()).build()).failSafeCommit()) {
                EconomyTransaction.TransactionSteps steps = transaction.getSteps();
                if (steps == EconomyTransaction.TransactionSteps.CHECK) {
                    MsgUtil.sendMessage((CommandSender)sender, "you-cant-afford-to-change-price", this.plugin.getEconomy().format(fee, shop.getLocation().getWorld(), shop.getCurrency()));
                } else {
                    MsgUtil.sendMessage((CommandSender)sender, "fee-charged-for-price-change", this.plugin.getEconomy().format(fee, shop.getLocation().getWorld(), shop.getCurrency()));
                    this.plugin.getLogger().log(Level.WARNING, "QuickShop can't pay taxes to the configured tax account! Please set the tax account name in the config.yml to an existing player: " + transaction.getLastError());
                }
                return;
            }
            shop.setPrice(price);
            shop.update();
            MsgUtil.sendMessage((CommandSender)sender, "price-is-now", this.plugin.getEconomy().format(shop.getPrice(), Objects.requireNonNull(shop.getLocation().getWorld()), shop.getCurrency()));
            if (!(shop instanceof ContainerShop)) {
                return;
            }
            ContainerShop cs = (ContainerShop)shop;
            if (!cs.isDoubleShop()) {
                return;
            }
            ContainerShop nextTo = cs.getAttachedShop();
            if (nextTo == null) {
                return;
            }
            if (cs.isSelling()) {
                if (cs.getPrice() < nextTo.getPrice()) {
                    MsgUtil.sendMessage((CommandSender)sender, "buying-more-than-selling", new String[0]);
                }
            } else if (cs.getPrice() > nextTo.getPrice()) {
                MsgUtil.sendMessage((CommandSender)sender, "buying-more-than-selling", new String[0]);
            }
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return cmdArg.length == 1 ? Collections.singletonList(MsgUtil.getMessage("tabcomplete.price", (CommandSender)sender, new String[0])) : Collections.emptyList();
    }

    public SubCommand_Price(QuickShop plugin) {
        this.plugin = plugin;
    }
}

