/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_RemoveAll
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length == 1) {
            ArrayList<Shop> tempList = new ArrayList<Shop>(this.plugin.getShopManager().getAllShops());
            Object shopOwner = null;
            for (OfflinePlayer player : this.plugin.getServer().getOfflinePlayers()) {
                if (player.getName() == null || !player.getName().equalsIgnoreCase(cmdArg[0])) continue;
                shopOwner = player;
                break;
            }
            if (shopOwner == null) {
                MsgUtil.sendMessage(sender, "unknown-player", new String[0]);
                return;
            }
            int i = 0;
            if (!shopOwner.equals(sender)) {
                if (!sender.hasPermission("quickshop.removeall.other")) {
                    MsgUtil.sendMessage(sender, "no-permission", new String[0]);
                    return;
                }
                for (Shop shop : tempList) {
                    if (!shop.getOwner().equals(shopOwner.getUniqueId())) continue;
                    this.plugin.log("Deleting shop " + shop + " as requested by the /qs removeall command.");
                    shop.delete();
                    ++i;
                }
            } else {
                if (!sender.hasPermission("quickshop.removeall.self")) {
                    MsgUtil.sendMessage(sender, "no-permission", new String[0]);
                    return;
                }
                if (!(sender instanceof OfflinePlayer)) {
                    sender.sendMessage(ChatColor.RED + "This command can't be run by the console!");
                    return;
                }
                for (Shop shop : tempList) {
                    if (!shop.getOwner().equals(((OfflinePlayer)sender).getUniqueId())) continue;
                    this.plugin.log("Deleting shop " + shop + " as requested by the /qs removeall command.");
                    shop.delete();
                    ++i;
                }
            }
            MsgUtil.sendMessage(sender, "command.some-shops-removed", Integer.toString(i));
        } else {
            MsgUtil.sendMessage(sender, "command.no-owner-given", new String[0]);
        }
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return cmdArg.length <= 1 ? Util.getPlayerList() : Collections.emptyList();
    }

    public SubCommand_RemoveAll(QuickShop plugin) {
        this.plugin = plugin;
    }
}

