/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_RemoveWorld
implements CommandHandler<CommandSender> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length < 1) {
            MsgUtil.sendMessage(sender, "command.no-world-given", new String[0]);
            return;
        }
        World world = Bukkit.getWorld((String)cmdArg[0]);
        if (world == null) {
            MsgUtil.sendMessage(sender, "world-not-exists", cmdArg[0]);
            return;
        }
        int shopsDeleted = 0;
        for (Shop shop : this.plugin.getShopManager().getAllShops()) {
            if (!shop.getLocation().getWorld().equals(world)) continue;
            shop.delete();
            ++shopsDeleted;
        }
        Util.debugLog("Successfully deleted all shops in world " + cmdArg[0] + "!");
        MsgUtil.sendMessage(sender, "shops-removed-in-world", String.valueOf(shopsDeleted), world.getName());
    }

    public SubCommand_RemoveWorld(QuickShop plugin) {
        this.plugin = plugin;
    }
}

