/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_SetOwner
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length < 1) {
            MsgUtil.sendMessage((CommandSender)sender, "command.no-owner-given", new String[0]);
            return;
        }
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        if (!bIt.hasNext()) {
            MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
            return;
        }
        while (bIt.hasNext()) {
            Block b = bIt.next();
            Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
            if (shop == null) continue;
            OfflinePlayer newShopOwner = this.plugin.getServer().getOfflinePlayer(cmdArg[0]);
            if (newShopOwner.getName() == null) {
                MsgUtil.sendMessage((CommandSender)sender, "unknown-player", new String[0]);
                return;
            }
            shop.setOwner(newShopOwner.getUniqueId());
            MsgUtil.sendMessage((CommandSender)sender, "command.new-owner", newShopOwner.getName());
            return;
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    @Override
    @NotNull
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return cmdArg.length <= 1 ? Util.getPlayerList() : Collections.emptyList();
    }

    public SubCommand_SetOwner(QuickShop plugin) {
        this.plugin = plugin;
    }
}

