/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collections;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.BlockIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Size
implements CommandHandler<Player> {
    private final QuickShop plugin;

    @Override
    public void onCommand(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        int amount;
        if (cmdArg.length < 1) {
            MsgUtil.sendMessage((CommandSender)sender, "command.bulk-size-not-set", new String[0]);
            return;
        }
        try {
            amount = Integer.parseInt(cmdArg[0]);
        }
        catch (NumberFormatException e) {
            MsgUtil.sendMessage((CommandSender)sender, "not-a-integer", cmdArg[0]);
            return;
        }
        BlockIterator bIt = new BlockIterator((LivingEntity)sender, 10);
        if (!bIt.hasNext()) {
            MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
            return;
        }
        while (bIt.hasNext()) {
            Block b = bIt.next();
            Shop shop = this.plugin.getShopManager().getShop(b.getLocation());
            if (shop == null) continue;
            if (shop.getModerator().isModerator(sender.getUniqueId()) || sender.hasPermission("quickshop.other.amount")) {
                if (amount <= 0 || amount > Util.getItemMaxStackSize(shop.getItem().getType())) {
                    MsgUtil.sendMessage((CommandSender)sender, "command.invalid-bulk-amount", Integer.toString(amount));
                    return;
                }
                shop.getItem().setAmount(amount);
                shop.refresh();
                MsgUtil.sendMessage((CommandSender)sender, "command.bulk-size-now", Integer.toString(shop.getItem().getAmount()), Util.getItemStackName(shop.getItem()));
                return;
            }
            MsgUtil.sendMessage((CommandSender)sender, "not-managed-shop", new String[0]);
        }
        MsgUtil.sendMessage((CommandSender)sender, "not-looking-at-shop", new String[0]);
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull Player sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return cmdArg.length == 1 ? Collections.singletonList(MsgUtil.getMessage("tabcomplete.amount", (CommandSender)sender, new String[0])) : Collections.emptyList();
    }

    public SubCommand_Size(QuickShop plugin) {
        this.plugin = plugin;
    }
}

