/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.command.subcommand;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.command.CommandHandler;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.MsgUtil;
import org.maxgamer.quickshop.util.Util;

public class SubCommand_Transfer
implements CommandHandler<ConsoleCommandSender> {
    private final QuickShop plugin;

    public SubCommand_Transfer(QuickShop plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onCommand(@NotNull ConsoleCommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        if (cmdArg.length == 1) {
            if (!(sender instanceof Player)) {
                MsgUtil.sendDirectMessage((CommandSender)sender, "This command can't be run by the console!");
                return;
            }
            OfflinePlayer targetPlayer = this.plugin.getServer().getOfflinePlayer(cmdArg[0]);
            String targetPlayerName = targetPlayer.getName();
            if (targetPlayerName == null) {
                targetPlayerName = "null";
            }
            UUID targetPlayerUUID = targetPlayer.getUniqueId();
            List<Shop> shopList = this.plugin.getShopManager().getPlayerAllShops(((Player)sender).getUniqueId());
            for (Shop shop : shopList) {
                shop.setOwner(targetPlayerUUID);
            }
            MsgUtil.sendMessage((CommandSender)sender, "command.transfer-success", Integer.toString(shopList.size()), targetPlayerName);
        } else if (cmdArg.length == 2) {
            OfflinePlayer targetPlayer;
            String targetPlayerName;
            if (!QuickShop.getPermissionManager().hasPermission((CommandSender)sender, "quickshop.transfer.other")) {
                MsgUtil.sendMessage((CommandSender)sender, "no-permission", new String[0]);
                return;
            }
            OfflinePlayer fromPlayer = this.plugin.getServer().getOfflinePlayer(cmdArg[0]);
            String fromPlayerName = fromPlayer.getName();
            if (fromPlayerName == null) {
                fromPlayerName = "null";
            }
            if ((targetPlayerName = (targetPlayer = this.plugin.getServer().getOfflinePlayer(cmdArg[1])).getName()) == null) {
                targetPlayerName = "null";
            }
            UUID targetPlayerUUID = targetPlayer.getUniqueId();
            List<Shop> shopList = this.plugin.getShopManager().getPlayerAllShops(fromPlayer.getUniqueId());
            for (Shop shop : shopList) {
                shop.setOwner(targetPlayerUUID);
            }
            MsgUtil.sendMessage((CommandSender)sender, "command.transfer-success-other", Integer.toString(shopList.size()), fromPlayerName, targetPlayerName);
        } else {
            MsgUtil.sendMessage((CommandSender)sender, "command.wrong-args", new String[0]);
        }
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull ConsoleCommandSender sender, @NotNull String commandLabel, @NotNull String[] cmdArg) {
        return cmdArg.length <= 2 ? Util.getPlayerList() : Collections.emptyList();
    }
}

