/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.sql.Connection;
import java.sql.SQLException;
import org.maxgamer.quickshop.database.AbstractDatabaseCore;

public class DatabaseConnection
implements AutoCloseable {
    private final Connection connection;
    private final AbstractDatabaseCore databaseCore;
    private volatile boolean using;

    public DatabaseConnection(AbstractDatabaseCore databaseCore, Connection connection) {
        this.databaseCore = databaseCore;
        this.connection = connection;
    }

    public synchronized boolean isValid() {
        try {
            return !this.connection.isClosed() && this.connection.isValid(8000);
        }
        catch (SQLException ignored) {
            return false;
        }
        catch (AbstractMethodError ignored) {
            return true;
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.markUsing();
            Connection connection = this.get();
            if (!connection.isClosed()) {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
                connection.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.release();
        }
    }

    synchronized void markUsing() {
        if (this.using) {
            throw new ConnectionIsUsingException();
        }
        this.using = true;
    }

    public synchronized Connection get() {
        if (this.using) {
            return this.connection;
        }
        throw new ConnectionIsNotUsingException();
    }

    public synchronized void release() {
        if (!this.using) {
            throw new ConnectionIsNotUsingException();
        }
        this.using = false;
        this.databaseCore.signalForNewConnection();
    }

    public synchronized boolean isUsing() {
        return this.using;
    }

    public static class ConnectionIsUsingException
    extends IllegalStateException {
    }

    public static class ConnectionIsNotUsingException
    extends IllegalStateException {
    }
}

