/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.database.DatabaseConnection;
import org.maxgamer.quickshop.database.DatabaseManager;
import org.maxgamer.quickshop.database.DatabaseTask;
import org.maxgamer.quickshop.database.MySQLCore;
import org.maxgamer.quickshop.database.WarpedResultSet;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.shop.ShopModerator;
import org.maxgamer.quickshop.util.Util;

public class DatabaseHelper {
    @NotNull
    private final DatabaseManager manager;
    @NotNull
    private final QuickShop plugin;

    public DatabaseHelper(@NotNull QuickShop plugin, @NotNull DatabaseManager manager) throws SQLException {
        this.plugin = plugin;
        this.manager = manager;
        if (!manager.hasTable(plugin.getDbPrefix() + "shops")) {
            this.createShopsTable();
        }
        if (!manager.hasTable(plugin.getDbPrefix() + "messages")) {
            this.createMessagesTable();
        }
        this.checkColumns();
    }

    private void createShopsTable() {
        String sqlString = "CREATE TABLE " + this.plugin.getDbPrefix() + "shops (owner  VARCHAR(255) NOT NULL, price  double(32, 2) NOT NULL, itemConfig TEXT CHARSET utf8 NOT NULL, x  INTEGER(32) NOT NULL, y  INTEGER(32) NOT NULL, z  INTEGER(32) NOT NULL, world VARCHAR(32) NOT NULL, unlimited  boolean, type  boolean, PRIMARY KEY (x, y, z, world) );";
        this.manager.runInstantTask(new DatabaseTask(sqlString));
    }

    private void createMessagesTable() {
        String createTable = "CREATE TABLE " + this.plugin.getDbPrefix() + "messages (owner  VARCHAR(255) NOT NULL, message  TEXT(25) NOT NULL, time  BIGINT(32) NOT NULL );";
        if (this.manager.getDatabase() instanceof MySQLCore) {
            createTable = "CREATE TABLE " + this.plugin.getDbPrefix() + "messages (owner  VARCHAR(255) NOT NULL, message  TEXT(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL , time  BIGINT(32) NOT NULL );";
        }
        this.manager.runInstantTask(new DatabaseTask(createTable));
    }

    private void checkColumns() {
        DatabaseTask.Task checkTask = new DatabaseTask.Task(){

            @Override
            public void edit(PreparedStatement ps) {
            }

            @Override
            public void onFailed(SQLException e) {
            }
        };
        this.manager.runInstantTask(new DatabaseTask("ALTER TABLE " + this.plugin.getDbPrefix() + "shops MODIFY COLUMN price double(32,2) NOT NULL AFTER owner", checkTask));
        this.manager.runInstantTask(new DatabaseTask("ALTER TABLE " + this.plugin.getDbPrefix() + "messages MODIFY COLUMN time BIGINT(32) NOT NULL AFTER message", checkTask));
        try {
            if (!this.manager.hasColumn(this.plugin.getDbPrefix() + "shops", "extra")) {
                String sqlString = this.manager.getDatabase() instanceof MySQLCore ? "ALTER TABLE " + this.plugin.getDbPrefix() + "shops ADD extra LONGTEXT" : "ALTER TABLE " + this.plugin.getDbPrefix() + "shops ADD COLUMN extra TEXT";
                this.manager.runInstantTask(new DatabaseTask(sqlString, new DatabaseTask.Task(){

                    @Override
                    public void edit(PreparedStatement ps) throws SQLException {
                    }

                    @Override
                    public void onFailed(SQLException e) {
                        Util.debugLog("Error to create EXTRA column: " + e.getMessage());
                    }
                }));
                Util.debugLog("Setting up the column EXTRA...");
            }
        }
        catch (SQLException e) {
            Util.debugLog("Error to create EXTRA column: " + e.getMessage());
        }
        if (this.manager.getDatabase() instanceof MySQLCore) {
            this.manager.runInstantTask(new DatabaseTask("ALTER TABLE " + this.plugin.getDbPrefix() + "messages MODIFY COLUMN message text CHARACTER SET utf8mb4 NOT NULL AFTER owner", checkTask));
        }
    }

    public void cleanMessage(long weekAgo) {
        String sqlString = "DELETE FROM " + this.plugin.getDbPrefix() + "messages WHERE time < ?";
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> ps.setLong(1, weekAgo)));
    }

    public void cleanMessageForPlayer(@NotNull UUID player) {
        String sqlString = "DELETE FROM " + this.plugin.getDbPrefix() + "messages WHERE owner = ?";
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> ps.setString(1, player.toString())));
    }

    public void createShop(final @NotNull Shop shop, final @Nullable Runnable onSuccess, final @Nullable Consumer<SQLException> onFailed) {
        this.removeShop(shop);
        String sqlString = "INSERT INTO " + this.plugin.getDbPrefix() + "shops (owner, price, itemConfig, x, y, z, world, unlimited, type, extra) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        this.manager.addDelayTask(new DatabaseTask(sqlString, new DatabaseTask.Task(){

            @Override
            public void edit(PreparedStatement ps) throws SQLException {
                Location location = shop.getLocation();
                ps.setString(1, ShopModerator.serialize(shop.getModerator()));
                ps.setDouble(2, shop.getPrice());
                ps.setString(3, Util.serialize(shop.getItem()));
                ps.setInt(4, location.getBlockX());
                ps.setInt(5, location.getBlockY());
                ps.setInt(6, location.getBlockZ());
                String worldName = "undefined";
                if (location.getWorld() != null) {
                    worldName = location.getWorld().getName();
                } else {
                    DatabaseHelper.this.plugin.getLogger().warning("Warning: Shop " + shop + " had null world name due we will save it as undefined world to trying keep data.");
                }
                ps.setString(7, worldName);
                ps.setInt(8, shop.isUnlimited() ? 1 : 0);
                ps.setInt(9, shop.getShopType().toID());
                ps.setString(10, shop.saveExtraToYaml());
            }

            @Override
            public void onSuccess() {
                if (!shop.isDeleted() && onSuccess != null) {
                    onSuccess.run();
                }
            }

            @Override
            public void onFailed(SQLException e) {
                if (onFailed != null) {
                    onFailed.accept(e);
                } else {
                    DatabaseHelper.this.plugin.getLogger().log(Level.WARNING, "Warning: Shop " + shop + " failed save to database, the shop may disappear after plugin reload or server restart!", e);
                }
            }
        }));
    }

    public void removeShop(Shop shop) {
        this.plugin.getShopLoader().removeShopFromShopLoader(shop);
        this.plugin.log("[DATABASE HELPER] Removing shop in the database: " + shop.toString());
        this.bakeTraceIfNeeded();
        String sqlString = "DELETE FROM " + this.plugin.getDbPrefix() + "shops WHERE x = ? AND y = ? AND z = ? AND world = ?" + (this.manager.getDatabase() instanceof MySQLCore ? " LIMIT 1" : "");
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> {
            Location location = shop.getLocation();
            ps.setInt(1, location.getBlockX());
            ps.setInt(2, location.getBlockY());
            ps.setInt(3, location.getBlockZ());
            ps.setString(4, location.getWorld().getName());
        }));
    }

    public void removeShop(String world, int x, int y, int z) {
        this.plugin.log("[DATABASE HELPER] Removing shop in the database: " + world + "/" + x + "/" + y + "z" + z);
        this.bakeTraceIfNeeded();
        String sqlString = "DELETE FROM " + this.plugin.getDbPrefix() + "shops WHERE x = ? AND y = ? AND z = ? AND world = ?" + (this.manager.getDatabase() instanceof MySQLCore ? " LIMIT 1" : "");
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> {
            ps.setInt(1, x);
            ps.setInt(2, y);
            ps.setInt(3, z);
            ps.setString(4, world);
        }));
    }

    public WarpedResultSet selectAllMessages() throws SQLException {
        return this.selectTable("messages");
    }

    private WarpedResultSet selectTable(String table) throws SQLException {
        DatabaseConnection databaseConnection = this.manager.getDatabase().getConnection();
        Statement st = databaseConnection.get().createStatement();
        String selectAllShops = "SELECT * FROM " + this.plugin.getDbPrefix() + table;
        ResultSet resultSet = st.executeQuery(selectAllShops);
        return new WarpedResultSet(st, resultSet, databaseConnection);
    }

    public WarpedResultSet selectAllShops() throws SQLException {
        return this.selectTable("shops");
    }

    public void sendMessage(@NotNull UUID player, @NotNull String message, long time) {
        String sqlString = "INSERT INTO " + this.plugin.getDbPrefix() + "messages (owner, message, time) VALUES (?, ?, ?)";
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> {
            ps.setString(1, player.toString());
            ps.setString(2, message);
            ps.setLong(3, time);
        }));
    }

    public void updateOwner2UUID(@NotNull String ownerUUID, int x, int y, int z, @NotNull String worldName) {
        String sqlString = "UPDATE " + this.plugin.getDbPrefix() + "shops SET owner = ? WHERE x = ? AND y = ? AND z = ? AND world = ?" + (this.manager.getDatabase() instanceof MySQLCore ? " LIMIT 1" : "");
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> {
            ps.setString(1, ownerUUID);
            ps.setInt(2, x);
            ps.setInt(3, y);
            ps.setInt(4, z);
            ps.setString(5, worldName);
        }));
    }

    public void updateShop(@NotNull String owner, @NotNull ItemStack item, int unlimited, int shopType, double price, int x, int y, int z, String world, String extra) {
        String sqlString = "UPDATE " + this.plugin.getDbPrefix() + "shops SET owner = ?, itemConfig = ?, unlimited = ?, type = ?, price = ?, extra = ? WHERE x = ? AND y = ? and z = ? and world = ?";
        this.manager.addDelayTask(new DatabaseTask(sqlString, ps -> {
            ps.setString(1, owner);
            ps.setString(2, Util.serialize(item));
            ps.setInt(3, unlimited);
            ps.setInt(4, shopType);
            ps.setDouble(5, price);
            ps.setString(6, extra);
            ps.setInt(7, x);
            ps.setInt(8, y);
            ps.setInt(9, z);
            ps.setString(10, world);
        }));
    }

    private void bakeTraceIfNeeded() {
        if (this.plugin.getConfig().getBoolean("debug.shop-deletion")) {
            for (StackTraceElement stackTraceElement : new Exception().getStackTrace()) {
                this.plugin.log("at [" + stackTraceElement.getClassName() + "] [" + stackTraceElement.getMethodName() + "] (" + stackTraceElement.getLineNumber() + ") - " + stackTraceElement.getFileName());
            }
        }
    }
}

