/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import lombok.NonNull;

public class DatabaseTask {
    private static final Task emptyTask = ps -> {};
    private final String statement;
    private final Task task;

    public DatabaseTask(String statement, Task task) {
        this.statement = statement;
        this.task = task;
    }

    public DatabaseTask(String statement) {
        this.statement = statement;
        this.task = emptyTask;
    }

    public void run(@NonNull Connection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try (PreparedStatement ps = connection.prepareStatement(this.statement);){
            this.task.edit(ps);
            ps.execute();
            this.task.onSuccess();
        }
        catch (SQLException e) {
            this.task.onFailed(e);
        }
    }

    public String toString() {
        return "DatabaseTask(statement=" + this.statement + ", task=" + this.task + ")";
    }

    static interface Task {
        public void edit(PreparedStatement var1) throws SQLException;

        default public void onSuccess() {
        }

        default public void onFailed(SQLException e) {
            e.printStackTrace();
        }
    }
}

