/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.economy;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.economy.EconomyType;
import org.maxgamer.quickshop.util.Util;

public class Economy
implements EconomyCore {
    private final QuickShop plugin;
    @NotNull
    private EconomyCore core;

    public Economy(@NotNull QuickShop plugin, @NotNull EconomyCore core) {
        this.plugin = plugin;
        this.core = core;
    }

    public static EconomyType getNowUsing() {
        return EconomyType.fromID(QuickShop.getInstance().getConfig().getInt("economy-type"));
    }

    public String toString() {
        return this.core.getClass().getName().split("_")[1];
    }

    @Override
    public boolean deposit(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        return this.core.deposit(name, amount, world, currency);
    }

    @Override
    public boolean deposit(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        return this.core.deposit(trader, amount, world, currency);
    }

    @Override
    public String format(double balance, @NotNull World world, @Nullable String currency) {
        return Util.parseColours(this.core.format(balance, world, currency));
    }

    @Override
    public double getBalance(@NotNull UUID name, @NotNull World world, @Nullable String currency) {
        return this.core.getBalance(name, world, currency);
    }

    @Override
    public double getBalance(@NotNull OfflinePlayer player, @NotNull World world, @Nullable String currency) {
        return this.core.getBalance(player, world, currency);
    }

    @Override
    public boolean transfer(@NotNull UUID from, @NotNull UUID to, double amount, @NotNull World world, @Nullable String currency) {
        return this.core.transfer(from, to, amount, world, currency);
    }

    @Override
    public boolean withdraw(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        return this.core.withdraw(name, amount, world, currency);
    }

    @Override
    public boolean withdraw(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        return this.core.withdraw(trader, amount, world, currency);
    }

    @Override
    public boolean hasCurrency(@NotNull World world, @NotNull String currency) {
        return this.core.hasCurrency(world, currency);
    }

    @Override
    public boolean supportCurrency() {
        return this.core.supportCurrency();
    }

    @Override
    public boolean isValid() {
        return this.core.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        return "BuiltIn-Economy Processor";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public EconomyCore getCore() {
        return this.core;
    }

    public void setCore(@NotNull EconomyCore core) {
        if (core == null) {
            throw new NullPointerException("core is marked non-null but is null");
        }
        this.core = core;
    }
}

