/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.economy;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.economy.Trader;
import org.maxgamer.quickshop.event.EconomyCommitEvent;
import org.maxgamer.quickshop.util.CalculateUtil;
import org.maxgamer.quickshop.util.Util;

public class EconomyTransaction {
    @Nullable
    private final UUID from;
    @Nullable
    private final UUID to;
    private final double amount;
    @NotNull
    private final EconomyCore core;
    private final double actualAmount;
    private final double tax;
    private final Trader taxer;
    private final boolean allowLoan;
    private final boolean tryingFixBanlanceInsuffient;
    private final World world;
    private final String currency;
    private final QuickShop plugin = QuickShop.getInstance();
    private TransactionSteps steps;
    @Nullable
    private String lastError = null;

    public EconomyTransaction(@Nullable UUID from, @Nullable UUID to, double amount, double taxModifier, @Nullable Trader taxAccount, EconomyCore core, boolean allowLoan, @NotNull World world, @Nullable String currency) {
        this.from = from;
        this.to = to;
        this.core = core == null ? QuickShop.getInstance().getEconomy() : core;
        this.amount = amount;
        this.steps = TransactionSteps.WAIT;
        this.taxer = taxAccount;
        this.allowLoan = allowLoan;
        this.world = world;
        this.currency = currency;
        this.actualAmount = Double.doubleToLongBits(taxModifier) != Double.doubleToLongBits(0.0) ? CalculateUtil.multiply(CalculateUtil.subtract(1.0, taxModifier), amount) : amount;
        this.tax = CalculateUtil.subtract(amount, this.actualAmount);
        if (from == null && to == null) {
            this.lastError = "From and To cannot be null in same time.";
            throw new IllegalArgumentException("From and To cannot be null in same time.");
        }
        this.tryingFixBanlanceInsuffient = QuickShop.getInstance() != null ? QuickShop.getInstance().getConfig().getBoolean("trying-fix-banlance-insuffient") : false;
        if (this.tryingFixBanlanceInsuffient) {
            if (from != null) {
                this.core.getBalance(from, world, currency);
            }
            if (to != null) {
                this.core.getBalance(to, world, currency);
            }
        }
    }

    public boolean failSafeCommit() {
        Util.debugLog("Transaction begin: FailSafe Commit --> " + this.from + " => " + this.to + "; Amount: " + this.amount + ", EconomyCore: " + this.core.getName());
        boolean result = this.commit();
        if (!result) {
            this.rollback(true);
        }
        return result;
    }

    public boolean commit() {
        return this.commit(new TransactionCallback(){

            @Override
            public void onSuccess(@NotNull EconomyTransaction economyTransaction) {
                if (EconomyTransaction.this.tryingFixBanlanceInsuffient) {
                    if (EconomyTransaction.this.from != null) {
                        EconomyTransaction.this.core.getBalance(EconomyTransaction.this.from, EconomyTransaction.this.world, EconomyTransaction.this.currency);
                    }
                    if (EconomyTransaction.this.to != null) {
                        EconomyTransaction.this.core.getBalance(EconomyTransaction.this.to, EconomyTransaction.this.world, EconomyTransaction.this.currency);
                    }
                }
            }
        });
    }

    public boolean commit(@NotNull TransactionCallback callback) {
        Util.debugLog("Transaction begin: Regular Commit --> " + this.from + " => " + this.to + "; Amount: " + this.amount + " Total(include tax): " + this.actualAmount + " Tax: " + this.tax + ", EconomyCore: " + this.core.getName());
        this.steps = TransactionSteps.CHECK;
        if (!callback.onCommit(this)) {
            this.lastError = "Plugin cancelled this transaction.";
            return false;
        }
        if (this.from != null && this.core.getBalance(this.from, this.world, this.currency) < this.amount && !this.allowLoan) {
            this.lastError = "From hadn't enough money";
            callback.onFailed(this);
            return false;
        }
        this.steps = TransactionSteps.WITHDRAW;
        if (this.from != null && !this.core.withdraw(this.from, this.amount, this.world, this.currency)) {
            this.lastError = "Failed to withdraw " + this.amount + " from player " + this.from + " account";
            callback.onFailed(this);
            return false;
        }
        this.steps = TransactionSteps.DEPOSIT;
        if (this.to != null && !this.core.deposit(this.to, this.actualAmount, this.world, this.currency)) {
            this.lastError = "Failed to deposit " + this.actualAmount + " to player " + this.to + " account";
            callback.onFailed(this);
            return false;
        }
        this.steps = TransactionSteps.TAX;
        if (this.tax > 0.0 && this.taxer != null && !this.core.deposit(this.taxer, this.tax, this.world, this.currency)) {
            this.lastError = "Failed to deposit tax account: " + this.tax;
            callback.onTaxFailed(this);
        }
        this.steps = TransactionSteps.DONE;
        callback.onSuccess(this);
        return true;
    }

    @NotNull
    public List<RollbackSteps> rollback(boolean continueWhenFailed) {
        ArrayList<RollbackSteps> rollbackSteps = new ArrayList<RollbackSteps>(3);
        if (this.steps == TransactionSteps.CHECK) {
            return rollbackSteps;
        }
        if (this.steps == TransactionSteps.WITHDRAW) {
            return rollbackSteps;
        }
        if (!(this.steps != TransactionSteps.DEPOSIT && this.steps != TransactionSteps.TAX || this.from == null || this.core.deposit(this.from, this.amount, this.world, this.currency) || continueWhenFailed)) {
            rollbackSteps.add(RollbackSteps.ROLLBACK_WITHDRAW);
            return rollbackSteps;
        }
        if (this.steps == TransactionSteps.TAX && this.to != null && !this.core.withdraw(this.to, this.actualAmount, this.world, this.currency) && !continueWhenFailed) {
            rollbackSteps.add(RollbackSteps.ROLLBACK_DEPOSIT);
            return rollbackSteps;
        }
        rollbackSteps.add(RollbackSteps.ROLLBACK_DONE);
        return rollbackSteps;
    }

    public static EconomyTransactionBuilder builder() {
        return new EconomyTransactionBuilder();
    }

    @Nullable
    public UUID getFrom() {
        return this.from;
    }

    @Nullable
    public UUID getTo() {
        return this.to;
    }

    public double getAmount() {
        return this.amount;
    }

    @NotNull
    public EconomyCore getCore() {
        return this.core;
    }

    public double getActualAmount() {
        return this.actualAmount;
    }

    public double getTax() {
        return this.tax;
    }

    public Trader getTaxer() {
        return this.taxer;
    }

    public boolean isAllowLoan() {
        return this.allowLoan;
    }

    public boolean isTryingFixBanlanceInsuffient() {
        return this.tryingFixBanlanceInsuffient;
    }

    public QuickShop getPlugin() {
        return this.plugin;
    }

    public World getWorld() {
        return this.world;
    }

    public String getCurrency() {
        return this.currency;
    }

    public TransactionSteps getSteps() {
        return this.steps;
    }

    @Nullable
    public String getLastError() {
        return this.lastError;
    }

    public static enum TransactionSteps {
        WAIT,
        CHECK,
        WITHDRAW,
        DEPOSIT,
        TAX,
        DONE;

    }

    static interface TransactionCallback {
        default public boolean onCommit(@NotNull EconomyTransaction economyTransaction) {
            return !Util.fireCancellableEvent(new EconomyCommitEvent(economyTransaction));
        }

        default public void onSuccess(@NotNull EconomyTransaction economyTransaction) {
            Util.debugLog("Transaction succeed.");
        }

        default public void onFailed(@NotNull EconomyTransaction economyTransaction) {
            Util.debugLog("Transaction failed: " + economyTransaction.getLastError() + ".");
        }

        default public void onTaxFailed(@NotNull EconomyTransaction economyTransaction) {
            Util.debugLog("Tax Transaction failed: " + economyTransaction.getLastError() + ".");
        }
    }

    private static enum RollbackSteps {
        ROLLBACK_WITHDRAW,
        ROLLBACK_DEPOSIT,
        ROLLBACK_TAX,
        ROLLBACK_DONE;

    }

    public static class EconomyTransactionBuilder {
        private UUID from;
        private UUID to;
        private double amount;
        private double taxModifier;
        private Trader taxAccount;
        private EconomyCore core;
        private boolean allowLoan;
        private World world;
        private String currency;

        EconomyTransactionBuilder() {
        }

        public EconomyTransactionBuilder from(@Nullable UUID from) {
            this.from = from;
            return this;
        }

        public EconomyTransactionBuilder to(@Nullable UUID to) {
            this.to = to;
            return this;
        }

        public EconomyTransactionBuilder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public EconomyTransactionBuilder taxModifier(double taxModifier) {
            this.taxModifier = taxModifier;
            return this;
        }

        public EconomyTransactionBuilder taxAccount(@Nullable Trader taxAccount) {
            this.taxAccount = taxAccount;
            return this;
        }

        public EconomyTransactionBuilder core(EconomyCore core) {
            this.core = core;
            return this;
        }

        public EconomyTransactionBuilder allowLoan(boolean allowLoan) {
            this.allowLoan = allowLoan;
            return this;
        }

        public EconomyTransactionBuilder world(@NotNull World world) {
            this.world = world;
            return this;
        }

        public EconomyTransactionBuilder currency(@Nullable String currency) {
            this.currency = currency;
            return this;
        }

        public EconomyTransaction build() {
            return new EconomyTransaction(this.from, this.to, this.amount, this.taxModifier, this.taxAccount, this.core, this.allowLoan, this.world, this.currency);
        }

        public String toString() {
            return "EconomyTransaction.EconomyTransactionBuilder(from=" + this.from + ", to=" + this.to + ", amount=" + this.amount + ", taxModifier=" + this.taxModifier + ", taxAccount=" + this.taxAccount + ", core=" + this.core + ", allowLoan=" + this.allowLoan + ", world=" + this.world + ", currency=" + this.currency + ")";
        }
    }
}

