/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.economy;

import java.math.BigDecimal;
import java.util.UUID;
import net.tnemc.core.TNE;
import net.tnemc.core.common.api.TNEAPI;
import net.tnemc.core.common.currency.TNECurrency;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.EconomyCore;

public class Economy_TNE
implements EconomyCore {
    private final QuickShop plugin;
    private final boolean allowLoan;
    private TNEAPI api;

    public Economy_TNE(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.allowLoan = plugin.getConfig().getBoolean("shop.allow-economy-loan");
        this.setupEconomy();
    }

    private void setupEconomy() {
        this.api = TNE.instance().api();
    }

    @Nullable
    private TNECurrency getCurrency(@NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return null;
        }
        if (currency != null) {
            for (TNECurrency apiCurrency : this.api.getCurrencies(world.getName())) {
                if (!apiCurrency.getIdentifier().equals(currency)) continue;
                return apiCurrency;
            }
        }
        return this.api.getDefault(world.getName());
    }

    @Override
    public boolean deposit(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        this.deposit(Bukkit.getOfflinePlayer((UUID)name), amount, world, currency);
        return false;
    }

    @Override
    public boolean deposit(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        BigDecimal decimal = BigDecimal.valueOf(amount);
        if (!this.api.canAddHoldings(trader.getUniqueId().toString(), decimal, this.getCurrency(world, currency), world.getName())) {
            return false;
        }
        return this.api.addHoldings(trader.getUniqueId().toString(), decimal, this.getCurrency(world, currency), world.getName());
    }

    @Override
    public String format(double balance, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return "Error";
        }
        BigDecimal decimal = BigDecimal.valueOf(balance);
        return this.api.format(decimal, this.getCurrency(world, currency), world.getName());
    }

    @Override
    public double getBalance(@NotNull UUID name, @NotNull World world, @Nullable String currency) {
        return this.getBalance(Bukkit.getOfflinePlayer((UUID)name), world, currency);
    }

    @Override
    public double getBalance(@NotNull OfflinePlayer player, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return 0.0;
        }
        if (this.getCurrency(world, currency) != null) {
            return this.api.getHoldings(player.getName(), this.getCurrency(world, currency)).doubleValue();
        }
        return this.api.getHoldings(player.getName(), world.getName()).doubleValue();
    }

    @Override
    public boolean withdraw(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        return this.withdraw(Bukkit.getOfflinePlayer((UUID)name), amount, world, currency);
    }

    @Override
    public boolean withdraw(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        BigDecimal decimal = BigDecimal.valueOf(amount);
        if (!this.api.canRemoveHoldings(trader.getUniqueId().toString(), decimal, this.getCurrency(world, currency), world.getName())) {
            return false;
        }
        return this.api.removeHoldings(trader.getUniqueId().toString(), decimal, this.getCurrency(world, currency), world.getName());
    }

    @Override
    public boolean hasCurrency(@NotNull World world, @NotNull String currency) {
        return this.getCurrency(world, currency) != null;
    }

    @Override
    public boolean supportCurrency() {
        return true;
    }

    @Override
    public boolean isValid() {
        return this.api != null && TNE.instance() != null;
    }

    @Override
    @NotNull
    public String getName() {
        return "BuiltIn-TNE";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public TNEAPI getApi() {
        return this.api;
    }

    public void setApi(TNEAPI api) {
        this.api = api;
    }
}

