/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.economy;

import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServiceRegisterEvent;
import org.bukkit.event.server.ServiceUnregisterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.economy.EconomyCore;
import org.maxgamer.quickshop.util.Util;

public class Economy_Vault
implements EconomyCore,
Listener {
    private static final String errorMsg = "QuickShop received an error when processing Economy response, THIS NOT A QUICKSHOP FAULT, you might need ask help with your Economy Provider plugin (%s) author.";
    private final QuickShop plugin;
    private final boolean allowLoan;
    @Nullable
    private Economy vault;

    public Economy_Vault(@NotNull QuickShop plugin) {
        this.plugin = plugin;
        this.allowLoan = plugin.getConfig().getBoolean("shop.allow-economy-loan");
        this.setupEconomy();
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider;
        if (!Util.isClassAvailable("net.milkbowl.vault.economy.Economy")) {
            return false;
        }
        try {
            economyProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        }
        catch (Exception e) {
            return false;
        }
        if (economyProvider != null) {
            this.vault = (Economy)economyProvider.getProvider();
        }
        if (this.vault == null) {
            return false;
        }
        if (this.vault.getName() == null || this.vault.getName().isEmpty()) {
            this.plugin.getLogger().warning("Current economy plugin not correct process all request, this usually cause by irregular code, you should report this issue to your economy plugin author or use other economy plugin.");
            this.plugin.getLogger().warning("This is technical information, please send this to economy plugin author: VaultEconomyProvider.getName() return a null or empty.");
        } else {
            this.plugin.getLogger().info("Using economy system: " + this.vault.getName());
        }
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        Util.debugLog("Economy service listener was registered.");
        return true;
    }

    @EventHandler
    public void onServiceRegister(ServiceRegisterEvent event) {
        if (!(event.getProvider() instanceof Economy)) {
            return;
        }
        this.setupEconomy();
    }

    @EventHandler
    public void onServiceUnregister(ServiceUnregisterEvent event) {
        if (!(event.getProvider() instanceof Economy)) {
            return;
        }
        this.setupEconomy();
    }

    @Override
    public boolean deposit(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        return this.deposit(this.plugin.getServer().getOfflinePlayer(name), amount, world, currency);
    }

    @Override
    public boolean deposit(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        try {
            return Objects.requireNonNull(this.vault).depositPlayer(trader, amount).transactionSuccess();
        }
        catch (Exception t) {
            this.plugin.getSentryErrorReporter().ignoreThrow();
            if (trader.getName() == null) {
                this.plugin.getLogger().warning("Deposit failed and player name is NULL, Player uuid: " + trader.getUniqueId() + ". Provider (" + this.getProviderName() + ")");
                return false;
            }
            this.plugin.getLogger().log(Level.WARNING, String.format(errorMsg, this.getProviderName()), t);
            return false;
        }
    }

    @Override
    public String format(double balance, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return "Error";
        }
        try {
            String formatedBalance = Objects.requireNonNull(this.vault).format(balance);
            if (formatedBalance == null) {
                return this.formatInternal(balance);
            }
            return formatedBalance;
        }
        catch (Exception e) {
            return this.formatInternal(balance);
        }
    }

    private String formatInternal(double balance) {
        if (!this.isValid()) {
            return "Error";
        }
        return Util.format(balance, true, (World)this.plugin.getServer().getWorlds().get(0), (String)null);
    }

    @Override
    public double getBalance(@NotNull UUID name, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return 0.0;
        }
        return this.getBalance(this.plugin.getServer().getOfflinePlayer(name), world, currency);
    }

    @Override
    public double getBalance(@NotNull OfflinePlayer player, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return 0.0;
        }
        if (player.getName() == null) {
            return 0.0;
        }
        try {
            return Objects.requireNonNull(this.vault).getBalance(player);
        }
        catch (Exception t) {
            this.plugin.getSentryErrorReporter().ignoreThrow();
            this.plugin.getLogger().log(Level.WARNING, String.format(errorMsg, this.getProviderName()), t);
            return 0.0;
        }
    }

    @Override
    public boolean withdraw(@NotNull UUID name, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        return this.withdraw(this.plugin.getServer().getOfflinePlayer(name), amount, world, currency);
    }

    @Override
    public boolean withdraw(@NotNull OfflinePlayer trader, double amount, @NotNull World world, @Nullable String currency) {
        if (!this.isValid()) {
            return false;
        }
        try {
            if (!this.allowLoan && this.getBalance(trader, world, currency) < amount) {
                return false;
            }
            return Objects.requireNonNull(this.vault).withdrawPlayer(trader, amount).transactionSuccess();
        }
        catch (Exception t) {
            this.plugin.getSentryErrorReporter().ignoreThrow();
            if (trader.getName() == null) {
                this.plugin.getLogger().warning("Withdraw failed and player name is NULL, Player uuid: " + trader.getUniqueId() + ", Provider: " + this.getProviderName());
                return false;
            }
            this.plugin.getLogger().log(Level.WARNING, String.format(errorMsg, this.getProviderName()), t);
            return false;
        }
    }

    @Override
    public boolean hasCurrency(@NotNull World world, @NotNull String currency) {
        return false;
    }

    @Override
    public boolean supportCurrency() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.vault != null;
    }

    @Override
    @NotNull
    public String getName() {
        return "BuiltIn-Vault";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public String getProviderName() {
        if (this.vault == null) {
            return "Provider not found.";
        }
        return String.valueOf(this.vault.getName());
    }

    @Nullable
    public Economy getVault() {
        return this.vault;
    }

    public void setVault(@Nullable Economy vault) {
        this.vault = vault;
    }
}

