/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.event;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxgamer.quickshop.event.QSEvent;
import org.maxgamer.quickshop.shop.Shop;

public class ShopSuccessPurchaseEvent
extends QSEvent
implements Cancellable {
    @NotNull
    private final Shop shop;
    private final int amount;
    @NotNull
    private final UUID purchaser;
    @Deprecated
    @Nullable
    private final Player player;
    @NotNull
    private final Inventory purchaserInventory;
    private final double tax;
    private final double total;
    private boolean cancelled;

    public ShopSuccessPurchaseEvent(@NotNull Shop shop, @NotNull UUID purchaser, @NotNull Inventory purchaserInventory, int amount, double total, double tax) {
        this.shop = shop;
        this.purchaser = purchaser;
        this.purchaserInventory = purchaserInventory;
        this.amount = amount * shop.getItem().getAmount();
        this.tax = tax;
        this.total = total;
        this.player = Bukkit.getPlayer((UUID)purchaser);
    }

    public double getBalance() {
        return this.total * (1.0 - this.tax);
    }

    public double getBalanceWithoutTax() {
        return this.total;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @NotNull
    public Shop getShop() {
        return this.shop;
    }

    public int getAmount() {
        return this.amount;
    }

    @NotNull
    public UUID getPurchaser() {
        return this.purchaser;
    }

    @Deprecated
    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Inventory getPurchaserInventory() {
        return this.purchaserInventory;
    }

    public double getTax() {
        return this.tax;
    }
}

