/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.factionsuuid;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.perms.PermissibleAction;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class FactionsUUIDIntegration
extends QSIntegratedPlugin {
    private final List<String> createFlags;
    private final List<String> tradeFlags;
    private final boolean createRequireOpen;
    private final boolean createRequireNormal;
    private final boolean createRequireWilderness;
    private final boolean createRequirePeaceful;
    private final boolean createRequirePermanent;
    private final boolean createRequireSafeZone;
    private final boolean createRequireOwn;
    private final boolean createRequireWarZone;
    private final boolean tradeRequireOpen;
    private final boolean tradeRequireNormal;
    private final boolean tradeRequireWilderness;
    private final boolean tradeRequirePeaceful;
    private final boolean tradeRequirePermanent;
    private final boolean tradeRequireSafeZone;
    private final boolean tradeRequireOwn;
    private final boolean tradeRequireWarZone;
    private final boolean whiteList;

    public FactionsUUIDIntegration(QuickShop plugin) {
        super(plugin);
        this.createFlags = plugin.getConfig().getStringList("integration.factions.create.flags");
        this.tradeFlags = plugin.getConfig().getStringList("integration.factions.trade.flags");
        this.whiteList = plugin.getConfig().getBoolean("integration.factions.whitelist-mode");
        this.createRequireOpen = plugin.getConfig().getBoolean("integration.factions.create.require.open");
        this.createRequireNormal = plugin.getConfig().getBoolean("integration.factions.create.require.normal");
        this.createRequireWilderness = plugin.getConfig().getBoolean("integration.factions.create.require.wilderness");
        this.createRequirePeaceful = plugin.getConfig().getBoolean("integration.factions.create.require.peaceful");
        this.createRequirePermanent = plugin.getConfig().getBoolean("integration.factions.create.require.permanent");
        this.createRequireSafeZone = plugin.getConfig().getBoolean("integration.factions.create.require.safezone");
        this.createRequireOwn = plugin.getConfig().getBoolean("integration.factions.create.require.own");
        this.createRequireWarZone = plugin.getConfig().getBoolean("integration.factions.create.require.warzone");
        this.tradeRequireOpen = plugin.getConfig().getBoolean("integration.factions.trade.require.open");
        this.tradeRequireNormal = plugin.getConfig().getBoolean("integration.factions.trade.require.normal");
        this.tradeRequireWilderness = plugin.getConfig().getBoolean("integration.factions.trade.require.wilderness");
        this.tradeRequirePeaceful = plugin.getConfig().getBoolean("integration.factions.trade.require.peaceful");
        this.tradeRequirePermanent = plugin.getConfig().getBoolean("integration.factions.trade.require.permanent");
        this.tradeRequireSafeZone = plugin.getConfig().getBoolean("integration.factions.trade.require.safezone");
        this.tradeRequireOwn = plugin.getConfig().getBoolean("integration.factions.trade.require.own");
        this.tradeRequireWarZone = plugin.getConfig().getBoolean("integration.factions.trade.require.warzone");
    }

    private static boolean check(@NotNull Player player, @NotNull Location location, boolean createRequireOpen, boolean createRequireSafeZone, boolean createRequirePermanent, boolean createRequirePeaceful, boolean createRequireWilderness, boolean createRequireWarZone, boolean createRequireNormal, boolean createRequireOwn, List<String> createFlags, boolean whiteList) {
        Faction faction = Board.getInstance().getFactionAt(new FLocation(location));
        if (faction == null) {
            return !whiteList;
        }
        if (createRequireOpen && !faction.getOpen()) {
            return false;
        }
        if (createRequireSafeZone && !faction.isSafeZone()) {
            return false;
        }
        if (createRequirePermanent && !faction.isPermanent()) {
            return false;
        }
        if (createRequirePeaceful && !faction.isPeaceful()) {
            return false;
        }
        if (createRequireWilderness && !faction.isWilderness()) {
            return false;
        }
        if (createRequireOpen && !faction.getOpen()) {
            return false;
        }
        if (createRequireWarZone && !faction.isWarZone()) {
            return false;
        }
        if (createRequireNormal && !faction.isNormal()) {
            return false;
        }
        if (createRequireOwn && !faction.getOwnerList(new FLocation(location)).contains(player.getName())) {
            return false;
        }
        for (String flag : createFlags) {
            if (faction.hasAccess(FPlayers.getInstance().getByPlayer(player), PermissibleAction.fromString((String)flag))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Factions";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull Location location) {
        return FactionsUUIDIntegration.check(player, location, this.createRequireOpen, this.createRequireSafeZone, this.createRequirePermanent, this.createRequirePeaceful, this.createRequireWilderness, this.createRequireWarZone, this.createRequireNormal, this.createRequireOwn, this.createFlags, this.whiteList);
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull Location location) {
        return FactionsUUIDIntegration.check(player, location, this.tradeRequireOpen, this.tradeRequireSafeZone, this.tradeRequirePermanent, this.tradeRequirePeaceful, this.tradeRequireWilderness, this.tradeRequireWarZone, this.tradeRequireNormal, this.tradeRequireOwn, this.tradeFlags, this.whiteList);
    }

    @Override
    public void load() {
    }

    @Override
    public void unload() {
    }
}

