/*
 * Decompiled with CFR 0.152.
 */
package org.maxgamer.quickshop.integration.plotsquared;

import com.github.intellectualsites.plotsquared.bukkit.events.PlayerPlotTrustedEvent;
import com.github.intellectualsites.plotsquared.bukkit.events.PlotDeleteEvent;
import com.github.intellectualsites.plotsquared.plot.flag.BooleanFlag;
import com.github.intellectualsites.plotsquared.plot.flag.Flag;
import com.github.intellectualsites.plotsquared.plot.flag.Flags;
import com.github.intellectualsites.plotsquared.plot.object.Location;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.maxgamer.quickshop.QuickShop;
import org.maxgamer.quickshop.integration.IntegrateStage;
import org.maxgamer.quickshop.integration.IntegrationStage;
import org.maxgamer.quickshop.integration.QSIntegratedPlugin;
import org.maxgamer.quickshop.shop.Shop;
import org.maxgamer.quickshop.util.Util;

@IntegrationStage(loadStage=IntegrateStage.onEnableAfter)
public class PlotSquaredIntegrationV4
extends QSIntegratedPlugin
implements Listener {
    private final boolean whiteList;
    private final boolean deleteUntrusted;
    private BooleanFlag createFlag;
    private BooleanFlag tradeFlag;

    public PlotSquaredIntegrationV4(QuickShop plugin) {
        super(plugin);
        this.whiteList = plugin.getConfig().getBoolean("integration.plotsquared.whitelist-mode");
        this.deleteUntrusted = plugin.getConfig().getBoolean("integration.plotsquared.delete-when-user-untrusted");
    }

    @Override
    @NotNull
    public String getName() {
        return "PlotSquared";
    }

    @Override
    public boolean canCreateShopHere(@NotNull Player player, @NotNull org.bukkit.Location location) {
        Location pLocation = new Location(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Plot plot = pLocation.getPlot();
        if (plot == null) {
            return !this.whiteList;
        }
        return this.createFlag.isTrue(plot);
    }

    @Override
    public boolean canTradeShopHere(@NotNull Player player, @NotNull org.bukkit.Location location) {
        Location pLocation = new Location(location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Plot plot = pLocation.getPlot();
        if (plot == null) {
            return !this.whiteList;
        }
        return this.tradeFlag.isFalse(plot);
    }

    @Override
    public boolean canDeleteShopHere(@NotNull Player player, @NotNull org.bukkit.Location location) {
        return false;
    }

    @Override
    public void load() {
        this.createFlag = new BooleanFlag("quickshop-create");
        this.tradeFlag = new BooleanFlag("quickshop-trade");
        Flags.registerFlag((Flag)this.createFlag);
        Flags.registerFlag((Flag)this.tradeFlag);
        this.plugin.getLogger().info(ChatColor.GREEN + this.getName() + " flags register successfully.");
        this.registerListener();
        Util.debugLog("Success register " + this.getName() + " flags.");
    }

    @Override
    public void unload() {
        this.unregisterListener();
    }

    private List<Shop> getShops(Plot plot) {
        ArrayList<Shop> shopsList = new ArrayList<Shop>();
        for (CuboidRegion region : plot.getRegions()) {
            for (int x = region.getMinimumPoint().getX() >> 4; x <= region.getMaximumPoint().getX() >> 4; ++x) {
                for (int z = region.getMinimumPoint().getZ() >> 4; z <= region.getMaximumPoint().getZ() >> 4; ++z) {
                    Map<org.bukkit.Location, Shop> shops = this.plugin.getShopManager().getShops(plot.getWorldName(), x, z);
                    if (shops == null) continue;
                    shopsList.addAll(shops.values());
                }
            }
        }
        return shopsList;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlotDelete(PlotDeleteEvent event) {
        this.getShops(event.getPlot()).forEach(Shop::delete);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlotUntrusted(PlayerPlotTrustedEvent event) {
        if (!this.deleteUntrusted) {
            return;
        }
        if (event.wasAdded()) {
            return;
        }
        this.getShops(event.getPlot()).stream().filter(shop -> shop.getOwner().equals(event.getPlayer())).forEach(Shop::delete);
    }
}

